/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.guibeans;

import java.io.Serializable;
import java.util.ArrayList;

public class GUIPatient implements Serializable
{
    public static final long serialVersionUID = 100;

    private String age;
    private String dob;
    private String dodEdipn;
    private String gender;
    private String localDodIen;
    private String localVAIen;
    private String name;
    private String patientId;
    private String patientIdSiteCode;
    private String ssn;
    private boolean sensitive;
    private String vistaIcn;
    private ArrayList<String> vistaLocations;

    public String getAge() {
        return age;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public String getDob() {
        return dob;
    }

    public void setDob(String dob) {
        this.dob = dob;
    }

    public String getDodEdipn() {
        return dodEdipn;
    }

    public void setDodEdipn(String dodEdipn) {
        this.dodEdipn = dodEdipn;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getLocalDodIen() {
        return localDodIen;
    }

    public void setLocalDodIen(String localDodIen) {
        this.localDodIen = localDodIen;
    }

    public String getLocalVAIen() {
        return localVAIen;
    }

    public void setLocalVAIen(String localVAIen) {
        this.localVAIen = localVAIen;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPatientId() {
        return patientId;
    }

    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    public String getPatientIdSiteCode() {
        return patientIdSiteCode;
    }

    public void setPatientIdSiteCode(String patientIdSiteCode) {
        this.patientIdSiteCode = patientIdSiteCode;
    }

    public String getSsn() {
        return ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public boolean isSensitive() {
        return sensitive;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public String getVistaIcn() {
        return vistaIcn;
    }

    public void setVistaIcn(String vistaIcn) {
        this.vistaIcn = vistaIcn;
    }

    public ArrayList<String> getVistaLocations() {
        return vistaLocations;
    }

    public void setVistaLocations(ArrayList<String> vistaLocations) {
        this.vistaLocations = vistaLocations;
    }
}
