/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.guibeans;

import java.io.Serializable;

/**
 *
 *
 */

public class GUIBean implements Serializable
{

    public static final long serialVersionUID = 100;

    private String siteCode;
    private String siteName;
    private String siteMoniker;
    private String siteAgency;
    private String sourcePlatform;
    private String recordDetailsToken;
    /** is bean to be stored in session? (notes (in/out), consults, problems) */
    private boolean sessionCachedRecord;

    public String getSiteCode() {
        return siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getSiteMoniker() {
        return siteMoniker;
    }

    public void setSiteMoniker(String siteMoniker) {
        this.siteMoniker = siteMoniker;
    }

    public String getSiteName() {
        return siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public String getRecordDetailsToken() {
        return recordDetailsToken;
    }

    public void setRecordDetailsToken(String recordDetailsToken) {
        this.recordDetailsToken = recordDetailsToken;
    }

    public boolean isSessionCachedRecord() {
        return sessionCachedRecord;
    }

    public void setSessionCachedRecord(boolean sessionCachedRecord) {
        this.sessionCachedRecord = sessionCachedRecord;
    }

    public String getSiteAgency() {
        return siteAgency;
    }

    public void setSiteAgency(String siteAgency) {
        this.siteAgency = siteAgency;
    }

    public String getSourcePlatform() {
        return sourcePlatform;
    }

    public void setSourcePlatform(String sourcePlatform) {
        this.sourcePlatform = sourcePlatform;
    }
}
