/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import gov.va.med.common.AppConstants;
import gov.va.med.guibeans.*;
import gov.va.med.vhahon.common.Utils;


import gov.va.med.jmeadows.webservice.RadiologyExam;
import gov.va.med.jmeadows.webservice.RadiologyReport;
import org.apache.commons.codec.binary.Base64;

public class RadiologyDao extends DaoBase
{
	public List<GUIRadiologyExam> getPatientRads(GUIProvider provider, GUIPatient patient, Calendar startDate, Calendar endDate)
	{
		try {
			RadiologyExam[] rads = getServiceHandler().getPatientRads(createQueryBean(provider, patient, startDate, endDate));
			
			List<GUIRadiologyExam> guiRads = new ArrayList<GUIRadiologyExam>();
			
			for(RadiologyExam rad : rads)
			{
				String examDate = "";
			    String study = "";
			    String status = "";
			    String examId = "";
			    String accessionNumber = "";
			    
			    if (rad.getExamDate() != null)
			    {
			    	examDate = Utils.formatDisplayDate(rad.getExamDate());
			    }
			    
			    if (rad.getStudy() != null)
			    {
			    	study = rad.getStudy();
			    }
			    
			    if (rad.getStatus() != null)
			    {
			    	status = rad.getStatus();
			    }
			    
			    if (rad.getExamId() != null)
			    {
			    	examId = rad.getExamId();
			    }
			    
			    if (rad.getAccessionNumber() != null)
			    {
			    	accessionNumber = rad.getAccessionNumber();
			    }
			    
			    GUIRadiologyExam guiRad = new GUIRadiologyExam();

                //for now med web viewing is only available at local dod and va
                if (AppConstants.LOCAL_SITE_CODE_DOD.equals(rad.getSiteCode()) ||
                        AppConstants.LOCAL_SITE_CODE_VA.equals(rad.getSiteCode()))
                {
                    guiRad.setMedWebAvailable(true);
                }
                else guiRad.setMedWebAvailable(false);

			    guiRad.setAccessionNumber(accessionNumber);
			    guiRad.setExamId(examId);
			    guiRad.setExamDate(examDate);
			    guiRad.setStatus(status);
			    guiRad.setStudy(study);

                addSiteDataToGUIBean(guiRad, rad);
			    
			    guiRads.add(guiRad);
			}
			
			return guiRads;
		} catch (Exception e) {
			throw new DaoException(e);
		}
	}
	
	public GUIRadiologyReport getRadiologyReport(GUIProvider provider, GUIPatient patient, String recordId, String recordSiteCode)
	{
		try {
			RadiologyReport radReport = getServiceHandler().getRadiologyReport(createQueryBean(provider, patient, recordId, recordSiteCode));
			
			String accessionNumber = "";
			String priority = "";
			String procedure = "";
			String examDate = "";
			String orderReason = "";
			String resultCode = "";
			String interpretingHCP = "";
			String approvingHCP = "";
			String transcribeDate = "";
			String reportStatus = "";
			String reportText = "";
			String impressionText = "";
			
			if (radReport.getAccessionNumber() != null)
			{
				accessionNumber = radReport.getAccessionNumber();
			}
			
			if (radReport.getReportText() != null)
			{
				reportText = radReport.getReportText();
                reportText = Utils.stringReplaceChars(reportText,(char)10,"<br>");
			}
			
			if (radReport.getPriority() != null)
			{
				priority = radReport.getPriority();
			}
			
			if (radReport.getStudy() != null)
			{
				procedure = radReport.getStudy();
			}
			
			if (radReport.getExamDate() != null)
			{
				examDate = Utils.formatDisplayDate(radReport.getExamDate());
			}
			
			if (radReport.getReasonForOrder() != null)
			{
				orderReason = radReport.getReasonForOrder();
                orderReason = Utils.stringReplaceChars(orderReason,(char)10,"<br>");
			}
			
			if (radReport.getResultCode() != null)
			{
				resultCode = radReport.getResultCode();
			}
			
			if (radReport.getInterpretingHCP() != null)
			{
				interpretingHCP = radReport.getInterpretingHCP();
			}
			
			if (radReport.getApprovedBy() != null)
			{
				approvingHCP = radReport.getApprovedBy();
			}
			
			if (radReport.getTranscribeDate() != null)
			{
				transcribeDate = Utils.formatDisplayDate(radReport.getTranscribeDate());
			}
			
			if (radReport.getReportStatus() != null)
			{
				reportStatus = radReport.getReportStatus();
			}
			
			if (radReport.getImpressionText() != null)
			{
				impressionText = radReport.getImpressionText();
                impressionText = Utils.stringReplaceChars(impressionText,(char)10,"<br>");
			}

            GUIRadiologyReport guiReport = new GUIRadiologyReport();


            //display a plain text report for the vista rpc platform
            if (AppConstants.PLATFORM_VISTA_RPC.equals(radReport.getSourcePlatform()))
            {
                guiReport.setPlainTextReport(true);
                guiReport.setMedWebAvailable(false);
            }
            //for now med web viewing is only available at tamc and vapihcs sites
            else guiReport.setMedWebAvailable(true);
			
			guiReport.setAccessionNumber(accessionNumber);
			guiReport.setProcedure(procedure);
			guiReport.setPriority(priority);
			guiReport.setExamDate(examDate);
			guiReport.setOrderReason(orderReason);
			guiReport.setResultCode(resultCode);
			guiReport.setOrderReason(orderReason);
			guiReport.setInterpretingHCP(interpretingHCP);
			guiReport.setApprovingHCP(approvingHCP);
			guiReport.setTranscribeDate(transcribeDate);
			guiReport.setImpressionText(impressionText);
			guiReport.setReportStatus(reportStatus);
			guiReport.setReportText(reportText);

            addSiteDataToGUIBean(guiReport, radReport);
			
			return guiReport;
			
		} catch (Exception e) {
			throw new DaoException(e);
		}
	}

    public GUIMedWebAccess getMedWebAccessBean(GUIProvider provider, GUIPatient patient,
                                               String accessionNumber, String recordSiteCode,
                                               String medWebURL, String medWebUserName, String medWebPassword)
    {

        GUIMedWebAccess guiMedWeb = new GUIMedWebAccess();

        guiMedWeb.setAccessionNumber(accessionNumber);
        String aeTitle = "NO_PACS_SELECTED";

        if (AppConstants.LOCAL_SITE_CODE_DOD.equals(recordSiteCode))
        {
            aeTitle = AppConstants.RADIOLOGY_PACS_NAME_LOCAL_DOD;
        }
        else if (AppConstants.LOCAL_SITE_CODE_VA.equals(recordSiteCode))
        {
            aeTitle = AppConstants.RADIOLOGY_PACS_NAME_LOCAL_VA;
        }

        guiMedWeb.setAeTitle(aeTitle);

        guiMedWeb.setMedWebUrl(medWebURL);

        //attempt to obfuscate medweb username and password
        String base64UserName = Base64.encodeBase64URLSafeString(medWebUserName.getBytes());
        String base64Password = Base64.encodeBase64URLSafeString(medWebPassword.getBytes());

        guiMedWeb.setMedWebUserName(base64UserName);
        guiMedWeb.setMedWebPassword(base64Password);

        try {
             getServiceHandler().logAudit(provider.getLoginSiteCode(), provider.getUserId(), "", provider.getName(), patient.getPatientId() + "^" + aeTitle + "^" + accessionNumber, "Medweb", "", "");
        } catch (Exception e) {
           throw new DaoException(e);
        }

        return guiMedWeb;
    }
}
