/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.dao;

import gov.va.med.common.AppConstants;
import gov.va.med.foundations.utilities.VistaKernelHash;
import gov.va.med.guibeans.GUIKeyValuePair;
import gov.va.med.guibeans.GUIProvider;
import gov.va.med.jmeadows.webservice.Provider;

import gov.va.med.jmeadows.webservice.UserSecurityKey;

import java.util.ArrayList;

/**
 *
 *
 */
public class ProviderDao extends DaoBase
{
    public GUIProvider login(String siteCode, String accessCode, String verifyCode)
    {
        try {
            if (AppConstants.LOCAL_SITE_CODE_VA.equals(siteCode))
            {
                accessCode = VistaKernelHash.encrypt(accessCode, false);
                verifyCode = VistaKernelHash.encrypt(verifyCode, false);
            }
            Provider provider = getServiceHandler().login(siteCode, accessCode, verifyCode);

            return toGUIProvider(provider);

        } catch (Exception ex) {
            throw new DaoException(ex);
        }
    }

    public String getProviderCfg(GUIProvider prov)
    {
        try {
            return getServiceHandler().getProviderCfg(createQueryBean(prov, ""));
        } catch (Exception ex) {
            throw new DaoException(ex);
        }
    }

    public boolean setProviderCfg(GUIProvider prov, String cfg)
    {
        try {
            return getServiceHandler().setProviderCfg(createQueryBean(prov,""), cfg);
        } catch (Exception ex) {
            throw new DaoException(ex);
        }
    }
}
