/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import gov.va.med.guibeans.GUIOrder;
import gov.va.med.guibeans.GUIOrderDetail;
import gov.va.med.guibeans.GUIPatient;
import gov.va.med.guibeans.GUIProvider;
import gov.va.med.vhahon.common.Utils;
import gov.va.med.jmeadows.webservice.Order;



public class OrderDao extends DaoBase
{
	public List<GUIOrder> getPatientOrders(GUIProvider provider, GUIPatient patient, Calendar startDate, Calendar endDate)
	{
		try {
			Order[] orders = getServiceHandler().getPatientOrders(createQueryBean(provider, patient, startDate, endDate));
			
			List<GUIOrder> guiOrders = new ArrayList<GUIOrder>();
			
			for(Order order : orders)
			{
				String orderDate = "";
				String orderId = "";
				String type = "";
				String providerName = "";
				String description = "";
				String status = "";

                if (order.getStartDate() != null){
                    orderDate = Utils.formatDisplayDate(order.getStartDate());
                }

				if (order.getOrderDate() != null)
				{
					orderDate = Utils.formatDisplayDate(order.getOrderDate());
				}
				
				if (order.getOrderid() != null)
				{
					orderId = order.getOrderid();
				}
				
				if (order.getType() != null)
				{
					type = order.getType();
				}
				
				if (order.getOrderingProvider() != null)
				{
					providerName = order.getOrderingProvider();
				}
				
				if (order.getDescription() != null)
				{
					description = order.getDescription();
				}
				
				if (order.getStatus() != null)
				{
					status = order.getStatus();
				}
				
				GUIOrder guiOrder = new GUIOrder();
				guiOrder.setDescription(description);
				guiOrder.setOrderDate(orderDate);
				guiOrder.setOrderId(orderId);
				guiOrder.setProviderName(providerName);
				guiOrder.setStatus(status);
				guiOrder.setType(type);

                addSiteDataToGUIBean(guiOrder, order);
				
				guiOrders.add(guiOrder);
			}
			
			return guiOrders;
			
		} catch (Exception e) {
			throw new DaoException(e);
		}		
	}
	
	public GUIOrderDetail getOrderDetail(GUIProvider provider, GUIPatient patient, String recordId,
                                         String recordSiteCode, String recordSiteMoniker,
                                         String recordSiteAgency, String recordSourcePlatform)
	{
		try {
			String report = getServiceHandler().getOrderDetail(createQueryBean(provider, patient, recordId, recordSiteCode));
			
			GUIOrderDetail orderDetail = new GUIOrderDetail();
			orderDetail.setOrderReport(report);
			orderDetail.setSiteCode(recordSiteCode);
            orderDetail.setSiteMoniker(recordSiteMoniker);
            orderDetail.setSiteAgency(recordSiteAgency);
            orderDetail.setSourcePlatform(recordSourcePlatform);
			
			return orderDetail;
			
		} catch (Exception e) {
			throw new DaoException(e);
		}
	}

    public List<GUIOrder> getProviderOrdersPending(
            GUIProvider provider,
            Calendar startDate,
            Calendar endDate,
            byte[] encryptSecurityKey)
	{
		try {

            Order[] orders = getServiceHandler().getProviderOrdersPending(createQueryBean(provider, null, startDate, endDate));

			List<GUIOrder> guiOrders = new ArrayList<GUIOrder>();

			for(Order order : orders)
			{
				String orderDate = "";
				String orderId = "";
				String type = "";
				String providerName = "";
				String description = "";
				String status = "";
                String patToken = "";
                String patientName = "";

				if (order.getOrderDate() != null)
				{
					orderDate = Utils.formatDisplayDate(order.getOrderDate());
				}

				if (order.getOrderid() != null)
				{
					orderId = order.getOrderid();
				}

				if (order.getType() != null)
				{
					type = order.getType();
				}

				if (order.getOrderingProvider() != null)
				{
					providerName = order.getOrderingProvider();
				}

				if (order.getDescription() != null)
				{
					description = order.getDescription();
				}

				if (order.getStatus() != null)
				{
					status = order.getStatus();
				}

                if (order.getPatientName()!=null){
                    patientName = order.getPatientName();
                }

                patToken = generatePatientToken(encryptSecurityKey, order.getPatientId(), order.getSiteCode());

				GUIOrder guiOrder = new GUIOrder();
				guiOrder.setDescription(description);
				guiOrder.setOrderDate(orderDate);
				guiOrder.setOrderId(orderId);
				guiOrder.setProviderName(providerName);
				guiOrder.setStatus(status);
				guiOrder.setType(type);

                addSiteDataToGUIBean(guiOrder, order);

                guiOrder.setPatientName(patientName);
                guiOrder.setPatientToken(patToken);

				guiOrders.add(guiOrder);
			}

			return guiOrders;

		} catch (Exception e) {
			throw new DaoException(e);
		}
	}

    public List<GUIOrder> getProviderOrdersResulted(
            GUIProvider provider,
            Calendar startDate,
            Calendar endDate,
            byte[] encryptSecurityKey)
	{
		try {
			Order[] orders = getServiceHandler().getProviderOrdersResulted(createQueryBean(provider, null, startDate, endDate));

			List<GUIOrder> guiOrders = new ArrayList<GUIOrder>();

			for(Order order : orders)
			{
				String orderDate = "";
				String orderId = "";
				String type = "";
				String providerName = "";
				String description = "";
				String status = "";
                String patientName = "";
                String patToken = "";

				if (order.getOrderDate() != null)
				{
					orderDate = Utils.formatDisplayDate(order.getOrderDate());
				}

				if (order.getOrderid() != null)
				{
					orderId = order.getOrderid();
				}

				if (order.getType() != null)
				{
					type = order.getType();
				}

				if (order.getOrderingProvider() != null)
				{
					providerName = order.getOrderingProvider();
				}

				if (order.getDescription() != null)
				{
					description = order.getDescription();
				}

				if (order.getStatus() != null)
				{
					status = order.getStatus();
				}

                if (order.getPatientName()!=null){
                    patientName = order.getPatientName();
                }

                patToken = generatePatientToken(encryptSecurityKey, order.getPatientId(), order.getSiteCode());


				GUIOrder guiOrder = new GUIOrder();
				guiOrder.setDescription(description);
				guiOrder.setOrderDate(orderDate);
				guiOrder.setOrderId(orderId);
				guiOrder.setProviderName(providerName);
				guiOrder.setStatus(status);
				guiOrder.setType(type);

                addSiteDataToGUIBean(guiOrder, order);

                guiOrder.setPatientName(patientName);
                guiOrder.setPatientToken(patToken);

				guiOrders.add(guiOrder);
			}

			return guiOrders;

		} catch (Exception e) {
			throw new DaoException(e);
		}
	}
}
