/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import gov.va.med.guibeans.*;
import gov.va.med.vhahon.common.Utils;
import gov.va.med.jmeadows.webservice.Medication;

import gov.va.med.jmeadows.webservice.Prescription;
import gov.va.med.jmeadows.webservice.PrescriptionFill;

import gov.va.med.jmeadows.webservice.QueryBean;

public class MedicationDao extends DaoBase
{	
	public static final int MEDICATION_STATUS_OUTPATIENT = 0;
	public static final int MEDICATION_STATUS_INPATIENT = 1;
	
	public List<GUIMedication> getPatientMedications(GUIProvider provider, GUIPatient patient, int medStatus, Calendar startDate, Calendar endDate)
	{	
		try 
		{
			String queryMedStatus = "I";
			if (medStatus == MEDICATION_STATUS_OUTPATIENT)
			{
				queryMedStatus = "O";
			}
			
			QueryBean qb = createQueryBean(provider, patient, startDate, endDate);
			qb.setStatus(queryMedStatus);
                        qb.setActive(new Integer(2));
			
			Medication[] meds = getServiceHandler().getPatientMedications(qb);
			
			List<GUIMedication> guiMeds = new ArrayList<GUIMedication>();
			
			for(Medication med : meds)
			{
				String fillOrderDate = "No Date";
				String drugName = "";
				String refills = "";
				String sig = "";
				String orderingProvider = "";
				String quantity = "";
				String daysSupply = "";
				String stopDate = "";
				String pharmacy = "";
				String comment = "";
				String medicationId = "";
			    String active = "";
			    
			    if (med.getFillOrderDate() != null)
			    {
			    	fillOrderDate = Utils.formatDisplayDate(med.getFillOrderDate());
			    }
			    
			    if (med.getDrugName() != null)
			    {
			    	drugName = med.getDrugName();
			    }
			    
			    if (med.getRefills() != null)
			    {
			    	refills = med.getRefills();
			    }
			    
			    if (med.getSigCode() != null)
			    {
			    	sig = med.getSigCode();
			    }
			    
			    if (med.getOrderingProvider() != null)
			    {
			    	orderingProvider = med.getOrderingProvider();
			    }
			    
			    if (med.getQuantity() != null)
			    {
			    	quantity = med.getQuantity();
			    }
			    
			    if (med.getDaysSupply() != null)
			    {
			    	daysSupply = med.getDaysSupply();
			    }
			    
			    if (med.getStopDate() != null)
			    {
			    	stopDate = Utils.formatDisplayDate(med.getStopDate());
			    }
			    
			    if (med.getLastDispensingPharmacy() != null)
			    {
			    	pharmacy = med.getLastDispensingPharmacy();
			    }
			    
			    if (med.getComment() != null)
			    {
			    	comment = med.getComment();
			    }
			    
			    if (med.getMedId() != null)
			    {
			    	medicationId = med.getMedId();
			    }
			    
			    if (med.getActive() != null)
			    {
			    	active = med.getActive();
			    }
			    
			    GUIMedication guiMed = new GUIMedication();
			    guiMed.setFillOrderDate(fillOrderDate);
			    guiMed.setDrugName(drugName);
			    guiMed.setRefills(refills);
			    guiMed.setSig(sig);
			    guiMed.setOrderingProvider(orderingProvider);
			    guiMed.setQuantity(quantity);
			    guiMed.setDaysSupply(daysSupply);
			    guiMed.setStopDate(stopDate);
			    guiMed.setPharmacy(pharmacy);
			    guiMed.setComment(comment);
			    guiMed.setMedicationId(medicationId);
			    guiMed.setActive(active);
			    addSiteDataToGUIBean(guiMed, med);
			    
			    guiMeds.add(guiMed);
			}
			
			return guiMeds;
			
		} catch (Exception e) {
			throw new DaoException(e);
		}
	}
	
	public GUIInpatientMedicationDetail getInpatientMedicationDetails(GUIProvider provider, GUIPatient patient, String medicationId,
                                                          String recordSiteCode, String recordSiteMoniker,
                                                          String recordSiteAgency, String recordSourcePlatform)
	{
		try {
			String inptMedDetailText = getServiceHandler().getInptMedicationDetail(createQueryBean(provider, patient, medicationId, recordSiteCode));
			GUIInpatientMedicationDetail inptMedDetail = new GUIInpatientMedicationDetail();
			inptMedDetail.setInptMedDetail(inptMedDetailText);
			inptMedDetail.setSiteCode(recordSiteCode);
            inptMedDetail.setSiteMoniker(recordSiteMoniker);
            inptMedDetail.setSiteAgency(recordSiteAgency);
            inptMedDetail.setSourcePlatform(recordSourcePlatform);
			
			return inptMedDetail;
		} catch (Exception e) {
			throw new DaoException(e);
		}
	}
	
	public List<GUIPrescriptionFill> getPrescriptionFills(GUIProvider provider, GUIPatient patient, String prescriptionId, String recordSiteCode)
	{
		try {
			Prescription rx = getServiceHandler().getPrescriptionFills(createQueryBean(provider, patient, prescriptionId, recordSiteCode));
			
			List<PrescriptionFill> rxFills = rx.getPrescriptionFills();
			
			String drugName = "";
			String quantity = "";;
			String daysSupply = "";;
			String expirationDate = "";;
			String comment = "";
			String fillOrderDate = "";
			String dispensingPharmacy = "";
			
			if (rx.getDrugName() != null)
			{
				drugName = rx.getDrugName();
			}
			
			if (rx.getQuantity() != null)
			{
				quantity = rx.getQuantity();
			}
			
			if (rx.getDaysSupply() != null)
			{
				daysSupply = rx.getDaysSupply();
			}
			
			if (rx.getStopDate() != null)
			{
				expirationDate = Utils.formatDisplayDate(rx.getStopDate());
			}
			
			if (rx.getComment() != null)
			{
				comment = rx.getComment();
			}
			
			if (rx.getFillOrderDate() != null)
			{
				fillOrderDate = Utils.formatDisplayDate(rx.getFillOrderDate());
			}
			
			if (rx.getLastDispensingPharmacy() != null)
			{
				dispensingPharmacy = rx.getLastDispensingPharmacy();
			}

            List<GUIPrescriptionFill> guiRxFills = new ArrayList<GUIPrescriptionFill>();

            if (rxFills != null && rxFills.size() > 0)
            {
                for(PrescriptionFill rxFill : rxFills)
                {
                    String rxFillFillOrderDate = "";
                    String rxFillDispensingPharmacy = "";
                    String rxFillQuantity = "";

                    if (rxFill.getDispenseDate() != null)
                    {
                        rxFillFillOrderDate = Utils.formatDisplayDateTime(rxFill.getDispenseDate());
                    }

                    if (rxFillFillOrderDate.length() < 2) fillOrderDate = "No Date";

                    if (rxFill.getDispensingPharmacy() != null)
                    {
                        rxFillDispensingPharmacy = rxFill.getDispensingPharmacy();
                    }

                    if (rxFill.getDispensingQuantity() != null)
                    {
                        rxFillQuantity = rxFill.getDispensingQuantity();
                    }

                    guiRxFills.add(generateGUIRXFill(rxFillFillOrderDate, drugName, rxFillQuantity,
                                        daysSupply, expirationDate, comment, rxFillDispensingPharmacy));
                }
            }
            else
            {
                guiRxFills.add(generateGUIRXFill(fillOrderDate, drugName, quantity,
                                    daysSupply, expirationDate, comment, dispensingPharmacy));
            }

			
			return guiRxFills;
		} catch (Exception e) {
			throw new DaoException(e);
		}
	}

    private GUIPrescriptionFill generateGUIRXFill(String fillOrderDate, String drugName, String quantity,
                                                  String daysSupply, String expirationDate, String comment,
                                                  String dispensingPharmacy)
    {
        GUIPrescriptionFill guiRxFill = new GUIPrescriptionFill();
        guiRxFill.setDrugName(drugName);
        guiRxFill.setComment(comment);
        guiRxFill.setDaysSupply(daysSupply);
        guiRxFill.setDispensingPharmacy(dispensingPharmacy);
        guiRxFill.setFillOrderDate(fillOrderDate);
        guiRxFill.setQuantity(quantity);
        guiRxFill.setExpirationDate(expirationDate);
        guiRxFill.setComment(comment);
        guiRxFill.setDispensingPharmacy(dispensingPharmacy);

        return guiRxFill;
    }
}
