/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.dao;

import gov.va.med.guibeans.GUIImmunization;
import gov.va.med.guibeans.GUIPatient;
import gov.va.med.guibeans.GUIProvider;
import gov.va.med.vhahon.common.Utils;
import gov.va.med.jmeadows.webservice.Immunization;



import java.util.ArrayList;
import java.util.List;


public class ImmunizationDao extends DaoBase
{
	public List<GUIImmunization> getPatientImmunizations(GUIProvider provider, GUIPatient patient)
	{
		try {
			Immunization[] imms = getServiceHandler().getPatientImmunizations(createQueryBean(provider, patient));
			
			List<GUIImmunization> guiImms = new ArrayList<GUIImmunization>();
			
			for(Immunization im : imms)
			{
				String adminDate = "";
				String vaccine = "";
				String reaction = "";
				String series = "";
				
				if (im.getDateTime() != null)
				{
					adminDate = Utils.formatDisplayDate(im.getDateTime());
				}
				
				if (im.getName() != null)
				{
					vaccine = im.getName();
				}
				
				if (im.getReaction() != null)
				{
					reaction = im.getReaction();
				}
				
				if (im.getSeries() != null)
				{
					series = im.getSeries();
				}
				
				GUIImmunization guiIm = new GUIImmunization();
				guiIm.setSeries(series);
				guiIm.setAdminDate(adminDate);
				guiIm.setReaction(reaction);
				guiIm.setVaccine(vaccine);
				addSiteDataToGUIBean(guiIm, im);
				
				guiImms.add(guiIm);
			}
			
			return guiImms;
			
		} catch (Exception e) {
			throw new DaoException(e);
		}
		
		
	}
}
