/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.dao;

import gov.va.med.common.AESCryptoUtil;
import gov.va.med.common.HttpKeys;
import gov.va.med.common.SSLUtilities;
import gov.va.med.guibeans.*;
import gov.va.med.jmeadows.JMeadowsServiceHandler;
import gov.va.med.jmeadows.webservice.*;
import gov.va.med.vhahon.common.Utils;
import groovy.util.ConfigObject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;



/**
 *
 *
 */
public class DaoBase 
{
    private static final Logger logger = Logger.getLogger(DaoBase.class.getName());

    private static final JMeadowsServiceHandler serviceHandler = new JMeadowsServiceHandler(
            (String)((ConfigObject) ConfigurationHolder.getConfig().getProperty("grails")).getProperty("jmeadowsURL"));

    static
    {
        Boolean trustAllSSLHostnamesAndCerts =
                (Boolean)((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("trustAllSSLHostnamesAndCerts");

        if (trustAllSSLHostnamesAndCerts.booleanValue())
        {
            SSLUtilities.trustAllHostnames();
            SSLUtilities.trustAllHttpsCertificates();
        }
    }

    public DaoBase()
    {

    }

    protected void addSiteDataToGUIBean(GUIBean guiBean, DataBean vistaBean)
    {
        guiBean.setSiteCode(vistaBean.getSiteCode());
        guiBean.setSiteName(vistaBean.getSiteName());
        guiBean.setSiteMoniker(vistaBean.getSiteMoniker());
        guiBean.setSiteAgency(vistaBean.getSiteAgency());
        guiBean.setSourcePlatform(vistaBean.getSourcePlatform());
    }

    protected void addSiteDataToGUIBean(GUIBean guiBean, PatientDemographics vistaBean)
    {
        guiBean.setSiteCode(vistaBean.getSiteCode());
        guiBean.setSiteName(vistaBean.getSiteName());
        guiBean.setSiteMoniker(vistaBean.getSiteMoniker());
        guiBean.setSiteAgency(vistaBean.getSiteAgency());
        guiBean.setSourcePlatform(vistaBean.getSourcePlatform());
    }

    protected void addSiteDataToGUIBean(GUIVitalsGraphEntry guiBean, DataBean vistaBean)
    {
        guiBean.setSiteCode(vistaBean.getSiteCode());
        guiBean.setSiteName(vistaBean.getSiteName());
        guiBean.setSiteMoniker(vistaBean.getSiteMoniker());
        guiBean.setSiteAgency(vistaBean.getSiteAgency());
        guiBean.setSourcePlatform(vistaBean.getSourcePlatform());
    }

    protected String generatePatientToken(byte[] encryptSecurityKey, String patientId, String patientSiteCode) throws Exception
    {
        String paramString =
                HttpKeys.PATIENT_ID+"="+patientId+
                "&"+HttpKeys.PATIENT_SITE_CODE+"="+patientSiteCode+
                "&"+HttpKeys.TIMESTAMP+"="+System.currentTimeMillis();
        
        return AESCryptoUtil.generateEncryptedQuery(encryptSecurityKey, paramString);
    }

    protected JMeadowsServiceHandler getServiceHandler()
    {
        return serviceHandler;
    }

    protected QueryBean createQueryBean(GUIProvider provider, GUIPatient patient,
                                                        Calendar startDate, Calendar endDate)
    {
        return createQueryBean(provider, patient, startDate, endDate, null, null, null, 0);
    }

    protected QueryBean createQueryBean(GUIProvider provider, GUIPatient patient,
                                                            Calendar startDate, Calendar endDate, String status)
    {
        return createQueryBean(provider, patient, startDate, endDate, status, null, null, 0);
    }

    protected QueryBean createQueryBean(GUIProvider provider, GUIPatient patient,
                                            Calendar startDate, Calendar endDate, String itemId, String recordSiteCode)
    {
        return createQueryBean(provider, patient, startDate, endDate, null, itemId, recordSiteCode, 0);
    }

    protected QueryBean createQueryBean(GUIProvider provider, GUIPatient patient)
    {
        return createQueryBean(provider, patient, null, null, null, null, null, 0);
    }
    
    protected QueryBean createQueryBean(GUIProvider provider, GUIPatient patient, int activeVal)
    {
        return createQueryBean(provider, patient, null, null, null, null, null, activeVal);
    }
    
    protected QueryBean createQueryBean(GUIProvider provider, GUIPatient patient, String itemId, String recordSiteCode)
    {
        return createQueryBean(provider, patient, null, null, null, itemId, recordSiteCode, 0);
    }

    protected QueryBean createQueryBean(GUIProvider provider, String itemId)
    {
        return createQueryBean(provider, null, null, null, null, itemId, null, 0);
    }

    protected QueryBean createQueryBean(GUIProvider provider, String itemId, String recordSiteCode)
    {
        return createQueryBean(provider, null, null, null, null, itemId, recordSiteCode, 0);
    }

    protected QueryBean createQueryBean(GUIProvider provider, GUIPatient patient,
                                                        Calendar startDate, Calendar endDate,
                                                        String status, String itemId,
                                                        String recordSiteCode, int activeVal)
    {

        XMLGregorianCalendar startXmlDate = null;
        XMLGregorianCalendar endXmlDate = null;

        if (startDate != null)
        {
            startXmlDate = Utils.toXMLGregorianCalendar(Utils.pushDateToStartOfDay(startDate.getTime()));
        }

        if (endDate != null)
        {
           endXmlDate = Utils.toXMLGregorianCalendar(Utils.pushDateToEndOfDay(endDate.getTime()));
        }

        QueryBean queryBean = new QueryBean();
        queryBean.setProvider(toProviderBean(provider));
        queryBean.setPatient(toPatientBean(patient));
        queryBean.setStartDate(startXmlDate);
        queryBean.setEndDate(endXmlDate);
        queryBean.setSortBy("");
        queryBean.setStatus(status);
        queryBean.setItemId(itemId);
        queryBean.setRequestingApp((String) ((ConfigObject) ConfigurationHolder.getConfig()).getProperty("appName"));
        queryBean.setRecordSiteCode(recordSiteCode);
        queryBean.setActive(new Integer(activeVal));

        return queryBean;
    }
    
    public class SiteAlphaComparator implements Comparator<GUIBean>
    {
		public int compare(GUIBean o1, GUIBean o2) {
			return o1.getSiteMoniker().compareTo(o2.getSiteMoniker());
		}	
    }

    protected Provider toProviderBean(GUIProvider guiProvider)
    {
        if (guiProvider == null) return null;

        Provider provider = new Provider();

        provider.setCfg(guiProvider.getCfg());
        provider.setDOB(guiProvider.getDob());
        provider.setDodProvider(guiProvider.isDodProvider());
        provider.setDutyPhone(guiProvider.getDutyPhone());
        provider.setEmail(guiProvider.getEmail());
        provider.setEncryptedAvCode(guiProvider.getEncryptedAvCode());
        provider.setGender(guiProvider.getGender());
        provider.setLoginSiteCode(guiProvider.getLoginSiteCode());
        provider.setLoginSiteName(guiProvider.getLoginSiteName());
        provider.setNPI(guiProvider.getNpi());
        provider.setName(guiProvider.getName());
        provider.setPager(guiProvider.getPager());
        provider.setPermissionString(guiProvider.getPermissionString());
        provider.setProviderClass(guiProvider.getProviderClass());
        provider.setProviderFlag(guiProvider.getProviderFlag());
        provider.setSSN(guiProvider.getSsn());
        provider.setSigClass(guiProvider.getSigClass());
        provider.setSigText(guiProvider.getSigText());
        provider.setUserId(guiProvider.getUserId());

        if (guiProvider.getPrimaryPermission() != null)
        {
            KeyValuePair primaryPermission = new KeyValuePair();
            primaryPermission.setKey(guiProvider.getPrimaryPermission().getKey());
            primaryPermission.setValue(guiProvider.getPrimaryPermission().getValue());

            provider.setPrimaryPermission(primaryPermission);
        }

        if (guiProvider.getLocationIdMappings() != null)
        {
            ArrayList<KeyValuePair> locationIdMappings = new ArrayList<KeyValuePair>();
            for(GUIKeyValuePair gKvp : guiProvider.getLocationIdMappings())
            {
                KeyValuePair kvp = new KeyValuePair();
                kvp.setKey(gKvp.getKey());
                kvp.setValue(gKvp.getValue());

                locationIdMappings.add(kvp);
            }

            provider.getLocationIdMappings().addAll(locationIdMappings);
        }

        if (guiProvider.getSecurityKeys() != null)
        {
            ArrayList<UserSecurityKey> securityKeys = new ArrayList<UserSecurityKey>();
            for(GUIUserSecurityKey gsKey: guiProvider.getSecurityKeys())
            {

                try {
                    UserSecurityKey sKey = new UserSecurityKey();
                    DatatypeFactory  df = DatatypeFactory.newInstance();
                    GregorianCalendar gregorianCalendarCD = new GregorianCalendar();
                    gregorianCalendarCD.setTime(gsKey.getCreationDate().getTime());

                    sKey.setCreationDate(df.newXMLGregorianCalendar(gregorianCalendarCD));
                    sKey.setCreatorId(gsKey.getCreatorId());
                    sKey.setCreatorName(gsKey.getCreatorName());
                    sKey.setDescriptiveName(gsKey.getDescriptiveName());
                    sKey.setId(gsKey.getId());
                    sKey.setKeyId(gsKey.getKeyId());
                    sKey.setName(gsKey.getName());

                    GregorianCalendar gregorianCalendarRD = new GregorianCalendar();
                    gregorianCalendarRD.setTime(gsKey.getReviewDate().getTime());

                    sKey.setReviewDate(df.newXMLGregorianCalendar(gregorianCalendarRD));

                    securityKeys.add(sKey);
                }
                catch (DatatypeConfigurationException e)
                {
                    logger.log(Level.ERROR, "Error while creating calendar", e);
                }
            }

            provider.getSecurityKeys().addAll(securityKeys);
        }

        if (guiProvider.getSitePermissions() != null)
        {
            ArrayList<KeyValuePair> sitePermissions = new ArrayList<KeyValuePair>();
            for(GUIKeyValuePair gKvp: guiProvider.getSitePermissions())
            {
                KeyValuePair kvp = new KeyValuePair();
                kvp.setKey(gKvp.getKey());
                kvp.setValue(gKvp.getValue());

                sitePermissions.add(kvp);
            }

            provider.getSitePermissions().addAll(sitePermissions);
        }

        return provider;
    }

    protected GUIProvider toGUIProvider(Provider provider)
    {
        if (provider == null) return null;

        GUIProvider guiProvider = new GUIProvider();

        guiProvider.setCfg(provider.getCfg());
        guiProvider.setDob(provider.getDOB());
        guiProvider.setDodProvider(provider.isDodProvider());
        guiProvider.setDutyPhone(provider.getDutyPhone());
        guiProvider.setEmail(provider.getEmail());
        guiProvider.setEncryptedAvCode(provider.getEncryptedAvCode());
        guiProvider.setGender(provider.getGender());
        guiProvider.setLoginSiteCode(provider.getLoginSiteCode());
        guiProvider.setLoginSiteName(provider.getLoginSiteName());
        guiProvider.setNpi(provider.getNPI());
        guiProvider.setName(provider.getName());
        guiProvider.setPager(provider.getPager());
        guiProvider.setPermissionString(provider.getPermissionString());
        guiProvider.setProviderClass(provider.getProviderClass());
        guiProvider.setProviderFlag(provider.getProviderFlag());
        guiProvider.setSsn(provider.getSSN());
        guiProvider.setSigClass(provider.getSigClass());
        guiProvider.setSigText(provider.getSigText());
        guiProvider.setUserId(provider.getUserId());

        if (provider.getPrimaryPermission() != null)
        {
            GUIKeyValuePair primaryPermission = new GUIKeyValuePair();
            primaryPermission.setKey(provider.getPrimaryPermission().getKey());
            primaryPermission.setValue(provider.getPrimaryPermission().getValue());
            guiProvider.setPrimaryPermission(primaryPermission);
        }


        if (provider.getLocationIdMappings() != null)
        {
            ArrayList<GUIKeyValuePair> locationIdMappings = new ArrayList<GUIKeyValuePair>();
            for(KeyValuePair kvp : provider.getLocationIdMappings())
            {
                GUIKeyValuePair gKvp = new GUIKeyValuePair();
                gKvp.setKey(kvp.getKey());
                gKvp.setValue(kvp.getValue());

                locationIdMappings.add(gKvp);
            }

            guiProvider.setLocationIdMappings(locationIdMappings);
        }

        if (provider.getSecurityKeys() != null)
        {
            ArrayList<GUIUserSecurityKey> securityKeys = new ArrayList<GUIUserSecurityKey>();
            for(UserSecurityKey sKey: provider.getSecurityKeys())
            {
                GUIUserSecurityKey gSKey = new GUIUserSecurityKey();
                gSKey.setCreationDate(sKey.getCreationDate().toGregorianCalendar());
                gSKey.setCreatorId(sKey.getCreatorId());
                gSKey.setCreatorName(sKey.getCreatorName());
                gSKey.setDescriptiveName(sKey.getDescriptiveName());
                gSKey.setId(sKey.getId());
                gSKey.setKeyId(sKey.getKeyId());
                gSKey.setName(sKey.getName());
                gSKey.setReviewDate(sKey.getReviewDate().toGregorianCalendar());

                securityKeys.add(gSKey);
            }

            guiProvider.setSecurityKeys(securityKeys);
        }

        if (provider.getSitePermissions() != null)
        {
            ArrayList<GUIKeyValuePair> sitePermissions = new ArrayList<GUIKeyValuePair>();
            for(KeyValuePair kvp : provider.getSitePermissions())
            {
                GUIKeyValuePair gKvp = new GUIKeyValuePair();
                gKvp.setKey(kvp.getKey());
                gKvp.setValue(kvp.getValue());

                sitePermissions.add(gKvp);
            }

            guiProvider.setSitePermissions(sitePermissions);
        }

        return guiProvider;
    }

    protected Patient toPatientBean(GUIPatient guiPatient)
    {
        if (guiPatient == null) return null;

        Patient patient = new Patient();

        patient.setAge(guiPatient.getAge());
        patient.setDob(guiPatient.getDob());
        patient.setDodEdipn(guiPatient.getDodEdipn());
        patient.setGender(guiPatient.getGender());
        patient.setLocalDodIen(guiPatient.getLocalDodIen());
        patient.setLocalVAIen(guiPatient.getLocalVAIen());
        patient.setName(guiPatient.getName());
        patient.setPatientId(guiPatient.getPatientId());
        patient.setPatientIdSiteCode(guiPatient.getPatientIdSiteCode());
        patient.setSSN(guiPatient.getSsn());
        patient.setSensitive(guiPatient.isSensitive());
        patient.setVistaIcn(guiPatient.getVistaIcn());

        if (guiPatient.getVistaLocations() != null)
        {
            ArrayList<String> vistaLocations = new ArrayList<String>();

            for(String loc : guiPatient.getVistaLocations())
            {
                vistaLocations.add(loc);
            }

            patient.getVistaLocations().addAll(vistaLocations);
        }

        return patient;
    }

    protected GUIPatient toGUIPatient(Patient patient)
    {
        if (patient == null) return null;

        GUIPatient guiPatient = new GUIPatient();

        guiPatient.setAge(patient.getAge());
        guiPatient.setDob(patient.getDob());
        guiPatient.setDodEdipn(patient.getDodEdipn());
        guiPatient.setGender(patient.getGender());
        guiPatient.setLocalDodIen(patient.getLocalDodIen());
        guiPatient.setLocalVAIen(patient.getLocalVAIen());
        guiPatient.setName(patient.getName());
        guiPatient.setPatientId(patient.getPatientId());
        guiPatient.setPatientIdSiteCode(patient.getPatientIdSiteCode());
        guiPatient.setSsn(patient.getSSN());
        guiPatient.setSensitive(patient.isSensitive());
        guiPatient.setVistaIcn(patient.getVistaIcn());

        if (patient.getVistaLocations() != null)
        {
            ArrayList<String> vistaLocations = new ArrayList<String>();

            for(String loc : patient.getVistaLocations())
            {
                vistaLocations.add(loc);
            }

            guiPatient.setVistaLocations(vistaLocations);
        }

        return guiPatient;
    }
}
