/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.dao;

import gov.va.med.guibeans.GUIClinicalReminder;
import gov.va.med.guibeans.GUIClinicalReminderDetail;
import gov.va.med.guibeans.GUIPatient;
import gov.va.med.guibeans.GUIProvider;
import gov.va.med.vhahon.common.Utils;
import gov.va.med.jmeadows.webservice.ClinicalReminder;


import java.util.ArrayList;
import java.util.List;

/**
 *
 *
 */
public class ClinicalReminderDao extends DaoBase {

    public List<GUIClinicalReminder> getPatientClinicalReminders(GUIProvider provider, GUIPatient patient, int activeVal) {
        try {
            ClinicalReminder[] reminders = getServiceHandler().getPatientClinicalReminders(
                    createQueryBean(provider, patient, activeVal));

            List<GUIClinicalReminder> guiReminders = new ArrayList<GUIClinicalReminder>();

            for (ClinicalReminder reminder : reminders) {
                GUIClinicalReminder guiReminder = new GUIClinicalReminder();

                String dueDate = "";
                String clinicalReminderId = "";
                String description = "";
                String lastDate = "";

                if (reminder.getDueDate() != null) {
                    dueDate = Utils.formatDisplayDate(reminder.getDueDate());
                }

                if (reminder.getId() != null) {
                    clinicalReminderId = reminder.getId();
                }

                if (reminder.getDescription() != null) {
                    description = reminder.getDescription();
                }

                if (reminder.getLastOccurrenceDate() != null) {
                    lastDate = Utils.formatDisplayDate(reminder.getLastOccurrenceDate());
                }

                guiReminder.setClinicalReminderId(clinicalReminderId);
                guiReminder.setDescription(description);
                guiReminder.setDueDate(dueDate);
                guiReminder.setLastDate(lastDate);
                addSiteDataToGUIBean(guiReminder, reminder);

                guiReminders.add(guiReminder);
            }

            return guiReminders;

        } catch (Exception ex) {
            throw new DaoException(ex);
        }
    }

    public GUIClinicalReminderDetail getClinicalReminderDetails(GUIProvider provider, GUIPatient patient, String recordId,
                                        String recordSiteCode, String recordSiteMoniker,
                                        String recordSiteAgency, String recordSourcePlatform) {
        try {
            String reminderText = getServiceHandler().getClinicalReminderDetail(createQueryBean(provider, patient, recordId, recordSiteCode));
            GUIClinicalReminderDetail guiReminderDetails = new GUIClinicalReminderDetail();
            guiReminderDetails.setClinicalReminderText(reminderText);
            guiReminderDetails.setSiteCode(recordSiteCode);
            guiReminderDetails.setSiteMoniker(recordSiteMoniker);
            guiReminderDetails.setSiteAgency(recordSiteAgency);
            guiReminderDetails.setSourcePlatform(recordSourcePlatform);

            return guiReminderDetails;

        } catch (Exception ex) {
            throw new DaoException(ex);
        }


    }
}
