/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.dao;

import gov.va.med.guibeans.GUIAppointment;
import gov.va.med.guibeans.GUIAppointmentDetail;
import gov.va.med.guibeans.GUIPatient;
import gov.va.med.guibeans.GUIProvider;
import gov.va.med.vhahon.common.Utils;

import gov.va.med.jmeadows.webservice.PatientAppointments;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 *
 *
 */
public class AppointmentDao extends DaoBase {

    public List<GUIAppointment> getPatientAppointments(GUIProvider provider, GUIPatient patient, Calendar startDate, Calendar endDate) {
        try {
            PatientAppointments[] appts = getServiceHandler().getPatientAppointments(createQueryBean(provider, patient, startDate, endDate));

            List<GUIAppointment> guiAppts = new ArrayList<GUIAppointment>();

            for (PatientAppointments appt : appts) {
                GUIAppointment guiAppt = new GUIAppointment();

                String apptDate = "";
                String clinic = "";
                String clinicId = "";
                String status = "";
                String type = "";
                String providerName = "";
                String reason = "";
                String appointmentId = "";

                if (appt.getProviderName() != null) {
                    providerName = appt.getProviderName();
                }

                if (appt.getClinic() != null) {
                    clinic = appt.getClinic();
                }

                if (appt.getClinicId() != null) {
                    clinicId = appt.getClinicId();
                }

                if (appt.getStatus() != null) {
                    status = appt.getStatus();
                }

                if (appt.getApptId() != null) {
                    appointmentId = appt.getApptId();
                }

                if (appt.getApptDate() != null) {
                    apptDate = Utils.formatDisplayDateTime(appt.getApptDate());
                }

                if (appt.getApptType() != null) {
                    type = appt.getApptType();
                }

                if (appt.getReason() != null) {
                    reason = appt.getReason();
                }

                guiAppt.setAppointmentDate(apptDate);
                guiAppt.setAppointmentId(appointmentId);
                guiAppt.setClinic(clinic);
                guiAppt.setClinicId(clinicId);
                guiAppt.setProviderName(providerName);
                guiAppt.setReason(reason);
                guiAppt.setStatus(status);
                guiAppt.setType(type);

                addSiteDataToGUIBean(guiAppt, appt);

                guiAppts.add(guiAppt);
            }

            return guiAppts;

        } catch (Exception ex) {
            throw new DaoException(ex);
        }
    }
    
    public GUIAppointmentDetail getAppointmentDetails(GUIProvider provider, GUIPatient patient, String appointmentId,
                                                      String recordSiteCode, String recordSiteMoniker,
                                                      String recordSiteAgency, String recordSourcePlatform)
    {
        try {
            String visitText = getServiceHandler().getVisitNotes(createQueryBean(provider, patient, appointmentId, recordSiteCode));
            
            GUIAppointmentDetail apptDetail = new GUIAppointmentDetail();
            apptDetail.setVisitDetails(visitText);
            apptDetail.setSiteCode(recordSiteCode);
            apptDetail.setSiteMoniker(recordSiteMoniker);
            apptDetail.setSiteAgency(recordSiteAgency);
            apptDetail.setSourcePlatform(recordSourcePlatform);
            
            return apptDetail;
        } catch (Exception ex) {
            throw new DaoException(ex);
        }
    }

    public List<GUIAppointment> getProviderAppointments(
            GUIProvider provider,
            Calendar startDate,
            Calendar endDate,
            byte[] encryptSecurityKey) {
        try {
            PatientAppointments[] appts = getServiceHandler().getProviderAppointments(createQueryBean(provider, null, startDate, endDate));

            List<GUIAppointment> guiAppts = new ArrayList<GUIAppointment>();

            for (PatientAppointments appt : appts) {
                GUIAppointment guiAppt = new GUIAppointment();

                String apptDate = "";
                String clinic = "";
                String status = "";
                String type = "";
                String providerName = "";
                String reason = "";
                String appointmentId = "";
                String patName = "";
                String patToken = "";

                if (appt.getProviderName() != null) {
                    providerName = appt.getProviderName();
                }

                if (appt.getClinic() != null) {
                    clinic = appt.getClinic();
                }

                if (appt.getStatus() != null) {
                    status = appt.getStatus();
                }

                if (appt.getApptId() != null) {
                    appointmentId = appt.getApptId();
                }

                if (appt.getApptDate() != null) {
                    apptDate = Utils.formatDisplayDateTime(appt.getApptDate());
                }

                if (appt.getApptType() != null) {
                    type = appt.getApptType();
                }

                if (appt.getReason() != null) {
                    reason = appt.getReason();
                }

                if (appt.getPatientName()!=null){
                    patName = appt.getPatientName();
                }

                patToken = generatePatientToken(encryptSecurityKey, appt.getPatientId(), appt.getSiteCode());


                guiAppt.setAppointmentDate(apptDate);
                guiAppt.setAppointmentId(appointmentId);
                guiAppt.setClinic(clinic);
                guiAppt.setProviderName(providerName);
                guiAppt.setReason(reason);
                guiAppt.setStatus(status);
                guiAppt.setType(type);
                addSiteDataToGUIBean(guiAppt, appt);
                guiAppt.setPatientName(patName);
                guiAppt.setPatientToken(patToken);

                guiAppts.add(guiAppt);
            }

            return guiAppts;

        } catch (Exception ex) {
            throw new DaoException(ex);
        }
    }
}
