/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.dao;

import gov.va.med.guibeans.GUIAllergy;
import gov.va.med.guibeans.GUIPatient;
import gov.va.med.guibeans.GUIProvider;
import gov.va.med.jmeadows.webservice.Allergy;


import java.util.ArrayList;
import java.util.List;

/**
 *
 *
 */
public class AllergyDao extends DaoBase {

    public List<GUIAllergy> getPatientAllergies(GUIProvider provider, GUIPatient patient) {
        try {
            Allergy[] allergies = getServiceHandler().getPatientAllergies(createQueryBean(provider, patient));

            List<GUIAllergy> guiAllergies = new ArrayList<GUIAllergy>();

            for (Allergy allergy : allergies) {
                
                String comment = "";
                String name = "";
                String severity = "";
                
                if (allergy.getComment() != null)
                {
                    comment = allergy.getComment();
                }
                
                if (allergy.getAllergyName() != null)
                {
                    name = allergy.getAllergyName();
                }
                
                if (allergy.getSeverity() != null)
                {
                    severity = allergy.getSeverity();
                }
                
                GUIAllergy guiAllergy = new GUIAllergy();

                guiAllergy.setComment(comment);
                guiAllergy.setName(name);
                guiAllergy.setSeverity(severity);

                addSiteDataToGUIBean(guiAllergy, allergy);

                guiAllergies.add(guiAllergy);
            }

            return guiAllergies;

        } catch (Exception ex) {
            throw new DaoException(ex);
        }

    }
}
