/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.dao;

import gov.va.med.guibeans.GUIAdmission;
import gov.va.med.guibeans.GUIAdmissionDetail;
import gov.va.med.guibeans.GUIPatient;
import gov.va.med.guibeans.GUIProvider;
import gov.va.med.vhahon.common.Utils;
import gov.va.med.jmeadows.webservice.AdmissionDetail;


import gov.va.med.jmeadows.webservice.PatientAdmission;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 *
 *
 */
public class AdmissionDao extends DaoBase {

    public List<GUIAdmission> getPatientAdmissions(GUIProvider provider, GUIPatient patient, Calendar startDate, Calendar endDate) {
        try {
            PatientAdmission[] admissions = getServiceHandler().getPatientAdmissions(
                    createQueryBean(provider, patient, startDate, endDate));

            List<GUIAdmission> guiAdms = new ArrayList<GUIAdmission>();

            for (PatientAdmission adm : admissions) {
                String admDate = "";
                String dcDate = "";
                String ward = "";
                String regnum = "";
                String admitId = "";
                String providerName = "";
                String diagnosisText = "";
                
                if (adm.getAdmissionDate() != null)
                {
                    admDate = Utils.formatDisplayDateTime(adm.getAdmissionDate());
                }

                if (adm.getDispositionDate() != null) {
                    dcDate = Utils.formatDisplayDateTime(adm.getDispositionDate());
                }
                
                if (adm.getWard() != null)
                {
                    ward = adm.getWard();
                }
                
                if (adm.getRegisterNumber() != null)
                {
                    regnum = adm.getRegisterNumber();
                }
                
                if (adm.getAdmissionId() != null)
                {
                    admitId = adm.getAdmissionId();
                }
                
                if (adm.getAdmittingProvider() != null)
                {
                    providerName = adm.getAdmittingProvider();
                }
                
                if (adm.getDrgDescription() != null)
                {
                    diagnosisText = adm.getDrgDescription();
                }

                GUIAdmission guiAdm = new GUIAdmission();
                guiAdm.setAdmissionDate(admDate);
                guiAdm.setDischargeDate(dcDate);
                guiAdm.setAdmissionId(admitId);
                guiAdm.setWard(ward);
                guiAdm.setRegistrationNum(regnum);
                guiAdm.setDiagnosisText(diagnosisText);
                guiAdm.setProviderName(providerName);

                addSiteDataToGUIBean(guiAdm, adm);

                guiAdms.add(guiAdm);
            }

            return guiAdms;

        } catch (Exception ex) {
            throw new DaoException(ex);
        }
    }

    public GUIAdmissionDetail getPatientAdmissionDetails(GUIProvider provider, GUIPatient patient, String admissionId,
                                     String recordSiteCode) {
        try {
            AdmissionDetail admissionDetail = getServiceHandler().
                    getAdmissionDetails(createQueryBean(provider, patient, admissionId, recordSiteCode));


            GUIAdmissionDetail guiAdmissionDetail = new GUIAdmissionDetail();
            guiAdmissionDetail.setDrgDescription(admissionDetail.getDrgDescription());
            addSiteDataToGUIBean(guiAdmissionDetail, admissionDetail);

            return guiAdmissionDetail;


        } catch (Exception ex) {
            throw new DaoException(ex);
        }
    }

    public List<GUIAdmission> getProviderAdmissions(
            GUIProvider provider,
            Calendar startDate,
            Calendar endDate,
            byte[] encryptSecurityKey) {
        try {
            PatientAdmission[] admissions = getServiceHandler().getProviderAdmissions(
                    createQueryBean(provider, null, startDate, endDate));

            List<GUIAdmission> guiAdms = new ArrayList<GUIAdmission>();

            for (PatientAdmission adm : admissions) {
                String admDate = "";
                String dcDate = "";
                String ward = "";
                String regnum = "";
                String admitId = "";
                String providerName = "";
                String diagnosisText = "";
                String patName = "";
                String patToken = "";

                if (adm.getAdmissionDate() != null)
                {
                    admDate = Utils.formatDisplayDateTime(adm.getAdmissionDate());
                }

                if (adm.getDispositionDate() != null) {
                    dcDate = Utils.formatDisplayDateTime(adm.getDispositionDate());
                }

                if (adm.getWard() != null)
                {
                    ward = adm.getWard();
                }

                if (adm.getRegisterNumber() != null)
                {
                    regnum = adm.getRegisterNumber();
                }

                if (adm.getAdmissionId() != null)
                {
                    admitId = adm.getAdmissionId();
                }

                if (adm.getAdmittingProvider() != null)
                {
                    providerName = adm.getAdmittingProvider();
                }

                if (adm.getDrgDescription() != null)
                {
                    diagnosisText = adm.getDrgDescription();
                }

                if (adm.getPatientName()!=null){
                    patName = adm.getPatientName();
                }

                patToken = generatePatientToken(encryptSecurityKey, adm.getPatientId(), adm.getSiteCode());

                GUIAdmission guiAdm = new GUIAdmission();
                guiAdm.setAdmissionDate(admDate);
                guiAdm.setDischargeDate(dcDate);
                guiAdm.setAdmissionId(admitId);
                guiAdm.setWard(ward);
                guiAdm.setRegistrationNum(regnum);
                guiAdm.setDiagnosisText(diagnosisText);
                guiAdm.setProviderName(providerName);
                addSiteDataToGUIBean(guiAdm, adm);
                guiAdm.setPatientName(patName);
                guiAdm.setPatientToken(patToken);

                guiAdms.add(guiAdm);
            }

            return guiAdms;

        } catch (Exception ex) {
            throw new DaoException(ex);
        }
    }
}
