/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.common;

import groovy.util.ConfigObject;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;

public class AppConstants
{
    //local sites
    public static final String LOCAL_SITE_CODE_VA = (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("localSiteCodeVA");

    public static final String LOCAL_SITE_CODE_DOD = (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("localSiteCodeDOD");

    //supported platforms
    public static final String PLATFORM_VISTA_RPC = (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("platformVistaRPC");
    public static final String PLATFORM_VISTA_CACHE =  (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("platformVistaCache");
    public static final String PLATF0RM_CHCS =  (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("platformCHCS");
    public static final String PLATF0RM_SHARE =  (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("platformSHARE");
    public static final String PLATF0RM_EDR =  (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("platformEDR");
    public static final String PLATF0RM_BHIE =  (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("platformBHIE");

    //supported agencies
    public static final String AGENCY_VA = (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("agencyVA");
    public static final String AGENCY_DOD = (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("agencyDOD");

    //radiology pac systems
    public static final String RADIOLOGY_PACS_NAME_LOCAL_VA = (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("radiologyPACSNameLocalVA");
    public static final String RADIOLOGY_PACS_NAME_LOCAL_DOD = (String) ((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("radiologyPACSNameLocalDOD");
}
