/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.common;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import gov.va.med.vhahon.common.Utils;
import groovy.util.ConfigObject;
import org.apache.commons.codec.net.URLCodec;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;

/**
 *
 *
 */
public class AESCryptoUtil {

    public static byte[] encrypt(byte[] securityKey, String message) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(securityKey, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
            return cipher.doFinal(message.getBytes());

        } catch (Exception e) {
            throw new RuntimeException("AES encryption failed", e);
        }
    }

    public static byte[] decrypt(byte[] securityKey, byte[] encrypted) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(securityKey, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.DECRYPT_MODE, skeySpec);
            return cipher.doFinal(encrypted);
        } catch (Exception e) {
            throw new RuntimeException("AES decryption failed", e);
        }
    }

    public static byte[] generateSecurityKey() {
        KeyGenerator generator;
        try {
            generator = KeyGenerator.getInstance("AES");
            generator.init(128);
            return generator.generateKey().getEncoded();

        } catch (Exception e) {
            throw new RuntimeException("AES generateSecurityKey failure", e);
        }
    }

    public static boolean isEncryptedTokenDebug()
    {
        Boolean val = (Boolean)((ConfigObject) ConfigurationHolder.getConfig().
                                    getProperty("grails")).getProperty("isEncryptedTokenDebug");
        
        return val.booleanValue();
    }

    public static String generateEncryptedQuery(byte[] securityKey, String queryParams) {
        if (isEncryptedTokenDebug()) {
            try {
                URLCodec urlCodec = new URLCodec();
                return urlCodec.encode(queryParams);
            } catch (EncoderException ex) {
                Logger.getLogger(AESCryptoUtil.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        } else {
            byte[] encryptedBytes = encrypt(securityKey, queryParams);
            return Base64.encodeBase64URLSafeString(encryptedBytes);
        }

    }

    public static Map decryptQuery(byte[] securityKey, String encryptedQuery) {
        String params;

        if (isEncryptedTokenDebug()) {
            try {
                URLCodec urlCodec = new URLCodec();
                params = urlCodec.decode(encryptedQuery);
            } catch (DecoderException ex) {
                Logger.getLogger(AESCryptoUtil.class.getName()).log(Level.SEVERE, null, ex);
                params = "";
            }
        } else {
            byte[] decryptBytes = decrypt(securityKey, Base64.decodeBase64(encryptedQuery));
            params = new String(decryptBytes);
        }

        return Utils.generateURLParameterMap(params);
    }
}
