%{--
  - Janus 4.0 (c)
  - Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
  - Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
  - Contributors:
  -             Honorable Senator Daniel K. Inouye
  -             VA Pacific Islands Health Care System
  -             Tripler Army Medical Center
  -
  - Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
  -
  - You may obtain a copy of the License at:
  -
  -            http://www.apache.org/licenses/LICENSE-2.0.txt
  -
  - Unless required by applicable law or agreed to in writing, software
  - distributed under the License is distributed on an "AS IS" BASIS,
  - WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  - See the License for the specific language governing permissions and limitations under the License.
  --}%

<%@ page contentType="text/html;charset=UTF-8" %>
<html xml:lang="en" lang="en">
<head>
<meta name="description" content="JANUS Provider Portal login page">
<title>Login</title>

<link rel="stylesheet" href="${resource(dir:'css',file:'login.css')}"/>

<script LANGUAGE="javascript" type="text/javascript">

    var siteCodeDOD = "${grailsConfig.localSiteCodeDOD}";
    var siteCodeVA = "${grailsConfig.localSiteCodeVA}";

    function SelectBox()
    {
        document.loginform.accessCode.focus();
    }

    function loginChoice(choice)
    {
        if (choice == siteCodeVA)
    	{
    		document.loginform.logintype.value="VistaLogin";
    		document.loginform.loginsitecode.value=choice;
    		document.loginform.submit();
    	}

    	if (choice == siteCodeDOD)
    	{
    		document.loginform.logintype.value="CHCSLogin";
    		document.loginform.loginsitecode.value=choice;
    		document.loginform.submit();
    	}

    	if (choice==""){
            alert("Please select a valid facility.")
        }

    }

    function checkFacility(facility){
        if(facility>0){
            document.loginform.btnLogon.disabled=false;
        } else {
            document.loginform.btnLogon.disabled=true;
        }
    }

    function openOnlineHelp()
    {
        var onlineHelpURL = '${resource(dir:'WebHelp',file:'iEHR_Help.htm')}';

        window.open(onlineHelpURL, "OnlineHelp", "status=1,resizable=1,scrollbars=1,menubar=0");
    }
</script>

</head>

<body class="loginBODY" onload="SelectBox();" >

<!-- Login Page Begins -->
<!-- table1 -->
<TABLE height="100%" cellSpacing=0 cellPadding=0 width="100%" border=0 bgclolor="#fffff">
  <TR>
    <TD valign=top align=center width=100% height=100%>
	  <div id="janusLogo">
      	<IMG alt="Janus Provider Portal Login" src="${resource(dir:'images',file:'loginLogo.png')}" border=0>
      </div>
      <div id="loginDivWrap">
        <div id="loginDiv">
          <g:form controller="authenticate" action="login" name="loginform">
                <div id="accessCode">
                    <span class="loginText">Access Code:</span><br>
                    <input type="password" name="accessCode" id="User Name" value="" maxlength="100" tabIndex="1" autocomplete="off" title="Enter Access Code" style="width: 285px;" aria-required="true">
                </div>
                <div id="verifyCode">
                    <span class="loginText">Verify Code:</span><br>
                    <input type="password" name="verifyCode" id="Password" value="" maxlength="100" tabIndex="2" autocomplete="off" title="Enter Verify Code" style="width: 285px;" aria-required="true">
                </div>
                <div id="facility">
                    <span class="loginText">Facility:</span><br>
                    <select id="loginLoc" name="siteCode" onChange="checkFacility(this.selectedIndex);" onkeyup="this.blur();this.focus();"  tabIndex="3">
                        <option value=""> </option>
                        <option value="${grailsConfig.localSiteCodeVA}" >${grailsConfig.localSiteLoginLabelVA}</option>
                        <option value="${grailsConfig.localSiteCodeDOD}">${grailsConfig.localSiteLoginLabelDOD}</option>
                  

                    </select>
                    <input type="button" onClick="loginChoice(document.loginform.siteCode.value);" value="Login" id="btnLogon" name="btnLogon" tabIndex="4"  title="Login using your VistA/CHCS AccessCode and VerifyCode" disabled>

                  <input type="hidden" name="loginmsg" value="">
                  <input type="hidden" name="logintype" value="VistaLogin">
                  <input type="hidden" name="loginsitecode" value="${grailsConfig.localSiteCodeVA}">
                </div>
          </g:form>
            <br/><br/>
                <div id="janusLoginHelp">
                    <span class="help-link" onclick="openOnlineHelp();">iEHR Help</span>
                </div>
            <div id="janusLoginError">
              <g:renderErrors bean="${loginCmd}" />
              <g:if test="${errorText}">
                ${errorText}
              </g:if>
            </div>
</div>
	  </div>
	  <div id="huiLogo" >
			<A href="http://www.pacifichui.org/" target=_blank
            alt="Pacific Telehealth &amp; Technology Hui"><IMG height=87
            alt="Janus Provider Portal logo" src="${resource(dir:'images',file:'loginHui.png')}"
            border=0></A>
	  </div>                <br><br>
	  <div id="loginFooterWrap">
	  	<DIV id="loginFooter">
	  		<div id="loginFooterText">
				This is a Federal Interest Automated System
				protected by Federal Law and may be accessed and used by authorized
				personnel only. All activities of personnel using this system may be
				monitored. Anyone using this system expressly consents to such
				monitoring and is advised that any evidence of unauthorized or
				criminal activity will be provided to the appropriate authorities.
				The information in this system is protected by the Privacy Act of
				1974 (PL-93-579). Unauthorized access to or use of this system is a
				violation of Federal Law. Violators will be
				prosecuted.
			</div>
	  	</DIV>
	  </div>
	</TD>
  </TR>
 </TABLE>
 <div style="display:none">
     Application Version: <g:meta name="app.version"/>
 </div>
</BODY></HTML>
