%{--
  - Janus 4.0 (c)
  - Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
  - Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
  - Contributors:
  -             Honorable Senator Daniel K. Inouye
  -             VA Pacific Islands Health Care System
  -             Tripler Army Medical Center
  -
  - Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
  -
  - You may obtain a copy of the License at:
  -
  -            http://www.apache.org/licenses/LICENSE-2.0.txt
  -
  - Unless required by applicable law or agreed to in writing, software
  - distributed under the License is distributed on an "AS IS" BASIS,
  - WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  - See the License for the specific language governing permissions and limitations under the License.
  --}%

<%@ page contentType="text/html;charset=UTF-8"%>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

        <script type="text/javascript"
			src="${resource(dir:'js',file:'ext-3.4.0/adapter/ext/ext-base.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js',file:'ext-3.4.0/ext-all.js')}?${appVersion}"></script>
        <script >
            Ext.namespace('Ext.hui');
            Ext.namespace('Ext.hui.session');

            Ext.hui.session.THEME_DEFAULT = "${resource(dir:'js',file:'ext-3.4.0/resources/css/ext-all.css')}?${appVersion}";
            Ext.hui.session.THEME_GRAY = "${resource(dir:'js',file:'ext-3.4.0/resources/css/xtheme-gray.css')}?${appVersion}";
            Ext.hui.session.THEME_BLUE = "${resource(dir:'js',file:'ext-3.4.0/resources/css/xtheme-blue.css')}?${appVersion}";
            Ext.hui.session.THEME_ACCESS = "${resource(dir:'js',file:'ext-3.4.0/resources/css/xtheme-access.css')}?${appVersion}";
            Ext.hui.session.THEME_DEFAULT2 = "${resource(dir:'css/default',file:'theme.css')}?${appVersion}";
            Ext.hui.session.THEME_GRAY2 = "${resource(dir:'css/gray',file:'theme.css')}?${appVersion}";
            Ext.hui.session.THEME_BLUE2 = "${resource(dir:'css/blue',file:'theme.css')}?${appVersion}";
            Ext.hui.session.THEME_ACCESS2 = "${resource(dir:'css/access',file:'theme.css')}?${appVersion}";

            <g:if test="${cfg != null && cfg.length() > 0}">
                Ext.hui.session.cfg = ${cfg};
            </g:if>
            <g:else>
                Ext.hui.session.cfg = "";
            </g:else>
        </script>
        <script type="text/javascript" src="${resource(dir:'js/hui/session',file:'session.js')}?${appVersion}"></script>

        <link rel="stylesheet" type="text/css"
			href="${resource(dir:'js',file:'ext-3.4.0/resources/css/ext-all.css')}?${appVersion}" />

        <g:if test="${theme == 'gray'}">
            <link rel="stylesheet" type="text/css"
			href="${resource(dir:'js',file:'ext-3.4.0/resources/css/xtheme-gray.css')}?${appVersion}" />
        </g:if>
        <g:elseif test="${theme == 'blue'}">
            <link rel="stylesheet" type="text/css"
			href="${resource(dir:'js',file:'ext-3.4.0/resources/css/xtheme-blue.css')}?${appVersion}" />
        </g:elseif>
        <g:elseif test="${theme == 'access'}">
            <link rel="stylesheet" type="text/css"
			href="${resource(dir:'js',file:'ext-3.4.0/resources/css/xtheme-access.css')}?${appVersion}" />
        </g:elseif>
		<link rel="stylesheet" href="${resource(dir:'css',file:'main.css')}?${appVersion}" />
		<link rel="stylesheet" href="${resource(dir:'css',file:'desktop.css')}?${appVersion}" />
		<link rel="stylesheet" href="${resource(dir:'css',file:'portlet.css')}?${appVersion}" />
		<link rel="stylesheet" href="${resource(dir:'css',file:'widget.css')}?${appVersion}" />
        <link rel="stylesheet" href="${resource(dir:'css',file:'filter.css')}?${appVersion}" />
		<link rel="stylesheet" href="${resource(dir:'css',file:'patientsearch.css')}?${appVersion}" />
		<link rel="stylesheet" href="${resource(dir:'css',file:'patient.css')}?${appVersion}" />
		<link rel="stylesheet" href="${resource(dir:'css',file:'patientdemographics.css')}?${appVersion}" />
		<link rel="stylesheet" href="${resource(dir:'css',file:'problemdetails.css')}?${appVersion}" />
        <link rel="stylesheet" href="${resource(dir:'css',file:'radiologyreport.css')}?${appVersion}" />
        <link rel="stylesheet" href="${resource(dir:'css',file:'labreport.css')}?${appVersion}" />
        <link rel="stylesheet" href="${resource(dir:'css',file:'labresults.css')}?${appVersion}" />
        <link rel="stylesheet" href="${resource(dir:'css',file:'vitals.css')}?${appVersion}" />
        <link rel="stylesheet" href="${resource(dir:'css',file:'bhiereport.css')}?${appVersion}" />

        <g:if test="${theme == ''}">

        </g:if>
        <g:elseif test="${theme == 'default'}">
            <link rel="stylesheet" href="${resource(dir:'css/default',file:'theme.css')}?${appVersion}" />
        </g:elseif>
        <g:elseif test="${theme == 'gray'}">
            <link rel="stylesheet" href="${resource(dir:'css/gray',file:'theme.css')}?${appVersion}" />
        </g:elseif>
        <g:elseif test="${theme == 'blue'}">
            <link rel="stylesheet" href="${resource(dir:'css/blue',file:'theme.css')}?${appVersion}" />
        </g:elseif>
        <g:elseif test="${theme == 'access'}">
            <link rel="stylesheet" href="${resource(dir:'css/access',file:'theme.css')}?${appVersion}" />
        </g:elseif>

		<!-- ENDLIBS -->



        <!-- graph javascripts -->
        <!--[if lte IE 8]><script type="text/javascript" src="${resource(dir:'js/flot',file:'excanvas.min.js')}?${appVersion}"></script><![endif]-->

        <!-- jquery is used by flot graphing lib -->
        <script type="text/javascript"
			src="${resource(dir:'js',file:'jquery.min.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/flot',file:'jquery.flot.min.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/flot',file:'jquery.flot.navigate.min.js')}?${appVersion}"></script>

        <!-- app javascripts -->
        <g:if test="${theme == 'access'}">
            <script type="text/javascript"
			src="${resource(dir:'js/ux',file:'Focus.js')}?${appVersion}"></script>
        </g:if>

        <script type="text/javascript"
			src="${resource(dir:'js/hui',file:'app.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/common',file:'common.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/ux',file:'PagingMemoryProxy.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'Filter.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'DateFilter.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'MedicationFilter.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'ImmunizationFilter.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'NoteFilter.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'ConsultFilter.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'RadiologyExamFilter.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'LabFilter.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'VitalsFilter.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'OrdersFilter.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/filter',file:'AppointmentsFilter.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/desktop',file:'TaskBar.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/desktop',file:'Desktop.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/desktop',file:'WidgetMenu.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/portal',file:'Portal.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/portal',file:'PortalColumn.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/portal',file:'PortalTabPanel.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/portal',file:'Portlet.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/portal',file:'Provider.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/portal',file:'Patient.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/widget',file:'Widget.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/widget',file:'WidgetIcon.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow',file:'DesktopWindow.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'PatientSearch.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'PatientDemographics.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'PatientDemographicsDetails.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'Admissions.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'Admissions.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'AdmissionDetails.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'Appointments.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'Appointments.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'AppointmentDetails.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'Allergies.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'Allergies.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'ProblemList.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'ProblemList.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'ProblemDetails.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'ProblemDetails.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'OutpatientMedications.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'OutpatientMedications.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'PrescriptionFills.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'InpatientMedications.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'InpatientMedications.js')}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'InpatientMedicationDetails.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'Immunizations.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'Immunizations.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'ProgressNotes.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'ProgressNotes.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'ProgressNoteDetails.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'DischargeSummaries.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'DischargeSummaries.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'DischargeSummaryDetails.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'Consults.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'Consults.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/patient',file:'ConsultDetails.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'ClinicalReminders.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'ClinicalReminders.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/patient',file:'ClinicalReminderDetails.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'Orders.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'Orders.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/patient',file:'OrderDetails.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/widget/patient',file:'RadiologyExams.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'RadiologyExams.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'RadiologyReport.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/widget/patient',file:'Labs.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/patient',file:'Labs.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/patient',file:'LabReport.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/patient',file:'LabResults.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/patient',file:'LabGraph.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/patient',file:'LabTable.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/patient',file:'Vitals.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'Vitals.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'VitalsGraph.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'VitalsTable.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/provider',file:'Admissions.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/provider',file:'Admissions.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/provider',file:'Appointments.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/provider',file:'Appointments.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/provider',file:'OrdersPending.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/provider',file:'OrdersPending.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/widget/provider',file:'OrdersResulted.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/provider',file:'OrdersResulted.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/widget/provider',file:'References.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/widget/provider',file:'ConsultsReceived.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/provider',file:'ConsultsReceived.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/widget/provider',file:'ConsultsRequested.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/provider',file:'ConsultsRequested.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/widget/provider',file:'UnsignedNotes.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/provider',file:'UnsignedNotes.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/widget/provider',file:'LabAbnormalResults.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/provider',file:'LabAbnormalResults.js')}?${appVersion}"></script>
        <script type="text/javascript"
            src="${resource(dir:'js/hui/desktopwindow/provider',file:'UIConfig.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/print',file:'Printer.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/print/renderers',file:'Base.js')}?${appVersion}"></script>
		<script type="text/javascript"
			src="${resource(dir:'js/print/renderers',file:'GridPanel.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/print/renderers',file:'Panel.js')}?${appVersion}"></script>
        <script type="text/javascript"
			src="${resource(dir:'js/hui/desktopwindow/patient',file:'AddNote.js')}?${appVersion}"></script>


        <script type="text/javascript">
            Ext.BLANK_IMAGE_URL = '${resource(dir:'js',file:'ext-3.4.0/resources/images/default/s.gif')}?${appVersion}';
            Ext.hui.app.APP_VERSION = '${appVersion}';
            Ext.hui.app.PLATFORM_VISTA_RPC = '${grailsConfig.platformVistaRPC}';
            Ext.hui.app.PLATFORM_VISTA_CACHE = '${grailsConfig.platformVistaCache}';
            Ext.hui.app.PLATFORM_CHCS = '${grailsConfig.platformCHCS}';
            Ext.hui.app.AGENCY_DOD = '${grailsConfig.agencyDOD}';
            Ext.hui.app.AGENCY_VA = '${grailsConfig.agencyVA}';
            Ext.hui.app.LOGOUT_URL = '<g:createLink controller="authenticate" action="logout"/>';
            Ext.hui.app.MEDWEB_PLUGIN_URL = '<g:resource dir="medweb" file="MedwebTelemedicineViewer.msi"/>';
            Ext.hui.app.ONLINE_HELP_URL =  '<g:resource dir="WebHelp" file="iEHR_Help.htm"/>';

        </script>

        <script>
            var loadCSS = function(file) {
                var link = document.createElement('link');
                link.href = file;
                link.rel = 'stylesheet';
                link.type = 'text/css';
                document.getElementsByTagName('head')[0].appendChild(link);
            };


        </script>

	</head>
	<body>
		<div id="ux-desktop" >
			<table id="header">
                <tr style="vertical-align:top;">
                <td id="headerLogo">
                    <span><img src="${resource(dir:'images',file:'default/jointTitle.png')}" alt="Joint DoD VA EHR" border="0" align="top"></span>
                </td>
                <td id="headerSearch">
                    <div id='searchWrap'>
                        <table class='searchBar'>
                            <tr>
                                <td>Patient search:&nbsp;&nbsp;</td>
                                <td><div id="patientsearch_textfield"></div></td>
                                <td><div id="patientsearch_button"></div></td>
                            </tr>
                        </table>
                    </div>
                </td>
                <td id="headerMenu">
                    <div id="menuWrap">
                        <table id="headerMenuTable">
                            <tr>
                                <td title="User Profile" class="userprofile-link" id="profile_menu_name">
                                    <g:if test="${siteIcon == 'DOD'}">
                                        <img src="${resource(dir:'images',file:'dodMarker.png')}"/>
                                    </g:if>
                                    <g:elseif test="${siteIcon == 'VA'}">
                                        <img src="${resource(dir:'images',file:'vaMarker.png')}"/>
                                    </g:elseif>
                                    ${providerName}
                                    &nbsp
                                    <!--img src="${resource(dir:'images',file:'default/profile_arrow.png')}"-->
                                </td>
                                <td id="logoutLink" ><div class="logoutButton" title="Logout" id="UILogout_button"></div>
                                    <g:link controller="authenticate" action="logout">logout</g:link>
                                    </td>
                                <td><div class="settings-link" title="Settings" id="UIConfig_button"></div></td>
                                <td><div class="help-link" title="Help" id="UIHelp_button"></div></td>
                            </tr>
                        </table>
                    </div>
                </td>
            </table>


			<div id="view_container">
				<span class='portalWindow' id='panel1'></span>
                <span class='portalWindow' id='panel2'>
					<div id='demographicsPanel'></div>
				</span>
                <span class='portalWindow' id='panel3'></span>
			</div>
            <div id="nav-button-left" style="display: none"></div>
            <div id="nav-button-right" style="display: none"></div>
            <div id="ux-widgetMenu"></div>
            <div id="ux-taskbar">
                <div id="ux-taskbar-start"></div>
                <div id="ux-taskbuttons-panel"></div>
                <div id="ux-taskbar-widgetButton">+</div>
                <div class="x-clear"></div>

            </div>
		</div>

	</body>
</html>
<!-- preload images as defined in main.css -->
<div id="preload-img-01"></div>
<div id="preload-img-02"></div>
<div id="dropPlaceholder"></div>