/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.ProviderDao

class UserCfgController extends BaseController
{

    def beforeInterceptor = {
        
        if (session.appUser.provider == null)
        {
            response.sendError 500
            return false;
        }

    }
    
    def save = {

        ProviderDao provDao = new ProviderDao()

        def result = provDao.setProviderCfg(
            session.appUser.provider,
            params['cfg'])

        if (result.value) {
            session.appUser.cfg = params['cfg']
            response.status = 200
            render "The config was saved successfuly."
        }
        else {
            response.status = 500
            render "Could not save the config: ${result} "
        }
        //sendResponse(result)
    }

    def show = {

        ProviderDao provDao = new ProviderDao()

        def result = provDao.getProviderCfg(
            session.appUser.provider)

        if (result!=null) {
            response.status = 200
            render "${result}"
        }
        else {
            response.status = 500
            render "Could not retrieve the config: ${result} "
        }
        //sendResponse(result)
    }


}

