/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.common.HttpKeys
import gov.va.med.dao.AdmissionDao
import gov.va.med.vhahon.common.Utils
import gov.va.med.common.Demo

class ProviderAdmissionsController extends BaseController
{    
    def beforeInterceptor = {
        
        if (session.appUser.provider == null)
        {
            response.sendError 500
            return false;
        }

        dateRangeCheck();
    }
    
    def show = {
     
        AdmissionDao admissionDao = new AdmissionDao()

        def guiAdmissions = admissionDao.getProviderAdmissions(
            session.appUser.provider,
            Utils.getCal(request[HttpKeys.START_DATE]),
            Utils.getCal(request[HttpKeys.END_DATE]),
            session.appUser.securityKey)
        
        //generate record details token
        if (guiAdmissions != null)
        {
            for(def guiAdm : guiAdmissions)
            {
                if (guiAdm.getAdmissionId() != null && guiAdm.getAdmissionId().length() > 0)
                {
                    def queryMap = [(HttpKeys.RECORD_ID): guiAdm.getAdmissionId()]
                    
                    guiAdm.setRecordDetailsToken(
                        generateRecordDetailsTokenWithPatToken(
                            guiAdm.getPatientToken(),
                            "patientAdmissionDetails",
                            queryMap, 
                            guiAdm.getSiteCode(), guiAdm.getSiteMoniker(),
                            guiAdm.getSiteAgency(), guiAdm.getSourcePlatform(),
                            false))
                }
                if (grailsApplication.config.scramble=="true"){
                    guiAdm.setPatientName(Demo.scramble(guiAdm.patientName));
                }
            }
        }
        sendResponse(guiAdmissions)
    }
}
