/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.common.HttpKeys
import gov.va.med.dao.PatientDao
import gov.va.med.common.AESCryptoUtil

class PatientSelectController extends BaseController {

    def beforeInterceptor = {

        if (params[HttpKeys.PATIENT_TOKEN] == null)
        {
            response.sendError 500
            return false;
        }
    }

    def show = {
        def patientToken = params[HttpKeys.PATIENT_TOKEN]

        def provider = session.appUser.provider
        def selectedPatientMap = session.appUser.selectedPatientMap

        def patientParams = AESCryptoUtil.decryptQuery(session.appUser.securityKey,patientToken)

        def paramPatientSiteCode = patientParams[HttpKeys.PATIENT_SITE_CODE]
        def paramPatientId = patientParams[HttpKeys.PATIENT_ID]

        PatientDao patientDao = new PatientDao()
        def selectedPatient = patientDao.selectPatient(provider, paramPatientId, paramPatientSiteCode)

        if (selectedPatient == null)
        {
            log.error("selected patient is null")
            response.sendError 500
            return false
        }

        selectedPatientMap.put(patientToken, selectedPatient)

        sendResponse(["patSelected":true])
    }
}
