/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.RadiologyDao
import gov.va.med.common.HttpKeys
import gov.va.med.vhahon.common.Utils
import org.apache.commons.beanutils.BeanUtils

class PatientRadiologyExamsController extends BaseController 
{

    def beforeInterceptor = {
        
        if (request.patient == null)
        {
            response.sendError 500
            return false;
        }

        dateRangeCheck();
    }
    
    def show = {
     
        RadiologyDao radiologyDao = new RadiologyDao()

        def guiRads = radiologyDao.getPatientRads(
			session.appUser.provider, 
			request.patient,
			Utils.getCal(request[HttpKeys.START_DATE]),
            Utils.getCal(request[HttpKeys.END_DATE]))
        
		//generate record details token
		if (guiRads != null)
		{
			for(def guiRad : guiRads)
			{	
				if (guiRad.getExamId() != null && 
					guiRad.getExamId().length() > 0)
				{
					def queryMap = [(HttpKeys.RECORD_ID): guiRad.getExamId(), (HttpKeys.ACCESSION_NUMBER): guiRad.getAccessionNumber()]
					guiRad.setRecordDetailsToken(
						generateRecordDetailsToken(
							request.patient.getPatientId(),
                            request.patient.getPatientIdSiteCode(),
							"patientRadiologyReport",
							queryMap,
							guiRad.getSiteCode(),
                            guiRad.getSiteMoniker(),
                            guiRad.getSiteAgency(),
                            guiRad.getSourcePlatform(),
                            guiRad.isSessionCachedRecord()))

                    if (guiRad.isMedWebAvailable())
                    {
                        guiRad.setMedWebToken(
                            generateRecordDetailsToken(
                                request.patient.getPatientId(),
                                request.patient.getPatientIdSiteCode(),
                                "patientMedWeb",
                                queryMap,
                                guiRad.getSiteCode(), guiRad.getSiteMoniker(),
                                guiRad.getSiteAgency(), guiRad.getSourcePlatform()))
                    }

                    if (guiRad.isSessionCachedRecord())
                    {
                        //cache radiology report in session
                        def guiRadDetail = BeanUtils.cloneBean(guiRad)

                        session.appUser.radiologyReportsMap.put(
                            getCachedRecordKey(guiRad.getRecordDetailsToken()), guiRadDetail)

						//don't send report text with rad exam listings
                        guiRad.setReportText("")
                    }
                }
			}
		}
		
        sendResponse(guiRads)
    }
}
