/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.NoteDao

import gov.va.med.vhahon.common.Utils
import gov.va.med.common.HttpKeys
import org.apache.commons.beanutils.BeanUtils

class PatientProgressNotesController extends BaseController
{

    def beforeInterceptor = {
        
        if (request.patient == null)
        {
            response.sendError 500
            return false;
        }

        dateRangeCheck();
    }
    
    def show = {
                
        NoteDao noteDao = new NoteDao()

        def guiOutpatientNotes = noteDao.getPatientProgressNotes(
            session.appUser.provider,
            request.patient, 
            Utils.getCal(request[HttpKeys.START_DATE]),
            Utils.getCal(request[HttpKeys.END_DATE]))
        
        if (guiOutpatientNotes != null)
        {
            for(def guiOutpatientNote : guiOutpatientNotes)
            {
                if (guiOutpatientNote.getNoteId() != null &&
                    guiOutpatientNote.getNoteId().length() > 0)
                {
                    def queryMap = [(HttpKeys.RECORD_ID): guiOutpatientNote.getNoteId()]
                    
                    guiOutpatientNote.setRecordDetailsToken(
                        generateRecordDetailsToken(
                            request.patient.getPatientId(),
                            request.patient.getPatientIdSiteCode(),
                            "patientProgressNoteDetails",
                            queryMap, 
                            guiOutpatientNote.getSiteCode(),
                            guiOutpatientNote.getSiteMoniker(),
                            guiOutpatientNote.getSiteAgency(),
                            guiOutpatientNote.getSourcePlatform(),
                            guiOutpatientNote.isSessionCachedRecord()))
                    
                    if (guiOutpatientNote.isSessionCachedRecord())
                    {
                        //cache outpatient progress note in session
                        def progressNoteDetail = BeanUtils.cloneBean(guiOutpatientNote)
                       
                        session.appUser.outpatientNotesMap.put(
                            getCachedRecordKey(guiOutpatientNote.getRecordDetailsToken()), progressNoteDetail)
                        
						//don't send note text with note listings
                        guiOutpatientNote.setNoteText("")
						guiOutpatientNote.setImages("")
                    }
                }
            }
        }

        sendResponse(guiOutpatientNotes)
    }
}
