/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.NoteDao
import gov.va.med.common.HttpKeys
import org.apache.commons.codec.binary.Base64
import gov.va.med.common.AppConstants

class PatientProgressNoteDetailsController extends PatientNoteDetailBaseController {

	def beforeInterceptor = {

		if (request.patient == null ||
			request.recordQuery == null) {
			response.sendError 500
			return false;
		}
	}

	def show = {
		NoteDao noteDao = new NoteDao()

		def guiNote = null

		if (request.isSessionCachedRecord) {
			guiNote = session.appUser.outpatientNotesMap.get(
					getCachedRecordKey(params[HttpKeys.RECORD_DETAILS_TOKEN]))
		}
		else {
			guiNote = noteDao.getProgressNote(
					session.appUser.provider,
					request.patient,
					request.recordQuery[HttpKeys.RECORD_ID],
					request.recordQuery[HttpKeys.RECORD_SITE_CODE],
                    request.recordQuery[HttpKeys.RECORD_SITE_MONIKER],
                    request.recordQuery[HttpKeys.RECORD_SITE_AGENCY],
                    request.recordQuery[HttpKeys.RECORD_SOURCE_PLATFORM])
		}

		//if dod note
		if (guiNote != null && (request.recordQuery[HttpKeys.RECORD_SOURCE_PLATFORM] == AppConstants.PLATF0RM_CHCS ||
                                request.recordQuery[HttpKeys.RECORD_SOURCE_PLATFORM] == AppConstants.PLATF0RM_BHIE ||
                                request.recordQuery[HttpKeys.RECORD_SOURCE_PLATFORM] == AppConstants.PLATF0RM_EDR))
		{
			String recordId = request.recordQuery[HttpKeys.RECORD_ID]
			String noteId = recordId.substring("cached:".length());
			String format = guiNote.getStatus()

			//if format is null, assume format is text
			if (format != null && format.length() > 0 &&
                    !format.contains("text") && !format.contains("TEXT"))
			{
                if (format.endsWith("eDR"))
				{
					//PDF marker:%PDF
					final int PDF_MARKER = 0x46445025;
	
					String noteText = guiNote.getImages()
	
					byte[] reportBytes = Base64.decodeBase64(noteText);
					int fileMarker = reportBytes[0] + (reportBytes[1] << 8) +
							(reportBytes[2] << 16) + (reportBytes[3] << 24);
	
					if (fileMarker == PDF_MARKER)
					{
						makePDF(noteText);
					}
					else {
						makeRTF(noteText);
					}
	
					return true;
				}
				else
				{
					String noteText = guiNote.getImages()
					makeCDAText(noteText);
					return true;
				}
			}
		}

		sendResponse(guiNote)
	}
}
