/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.ProblemDao
import gov.va.med.common.HttpKeys
import gov.va.med.common.AppConstants

class PatientProblemListController extends BaseController {
    def beforeInterceptor = {
        
        if (request.patient == null)
        {
            response.sendError 500
            return false;
        }
    }
    
    def show = {
                
        ProblemDao problemDao = new ProblemDao()

        def guiProblems = problemDao.getPatientProblemList(session.appUser.provider,
            request.patient, params.status)
        
        if (guiProblems != null)
        {
            for(def guiProb : guiProblems)
            {
                //no record details for chcs problems
				if (guiProb.getProblemId() != null &&
                    guiProb.getProblemId().length() > 0 &&
                    guiProb.getSourcePlatform() != AppConstants.PLATF0RM_CHCS)
                {
                    def queryMap = [(HttpKeys.RECORD_ID): guiProb.getProblemId()]
                    
                    guiProb.setRecordDetailsToken(
                        generateRecordDetailsToken(
                            request.patient.getPatientId(),
                            request.patient.getPatientIdSiteCode(),
                            "patientProblemDetails",
                            queryMap, 
                            guiProb.getSiteCode(),
                            guiProb.getSiteMoniker(),
                            guiProb.getSiteAgency(),
                            guiProb.getSourcePlatform(),
                            guiProb.isSessionCachedRecord()))
                    
                    if (guiProb.isSessionCachedRecord())
                    {
                        //cache problem in session
                        session.appUser.problemListMap.put(
                            getCachedRecordKey(guiProb.getRecordDetailsToken()), guiProb)
                    }
                }
            }
        }

        sendResponse(guiProblems)
    }
}
