/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.MedicationDao
import gov.va.med.common.HttpKeys
import gov.va.med.vhahon.common.Utils
import gov.va.med.common.AppConstants
import org.apache.commons.beanutils.BeanUtils
import gov.va.med.guibeans.GUIPrescriptionFill

class PatientOutpatientMedicationsController extends BaseController 
{

    def beforeInterceptor = {
        
        if (request.patient == null)
        {
            response.sendError 500
            return false;
        }

        dateRangeCheck();
    }
    
    def show = {
     
        MedicationDao medicationDao = new MedicationDao()

        def guiMeds = medicationDao.getPatientMedications(
			session.appUser.provider, 
			request.patient,
			MedicationDao.MEDICATION_STATUS_OUTPATIENT,
			Utils.getCal(request[HttpKeys.START_DATE]),
            Utils.getCal(request[HttpKeys.END_DATE]))
        
		//generate record details token
		if (guiMeds != null)
		{
			for(def guiMed : guiMeds)
			{
				//only allow outpatient med details for chcs and vista cache
				if (guiMed.getMedicationId() != null &&
					guiMed.getMedicationId().length() > 0 &&
                     (guiMed.getSourcePlatform() == AppConstants.PLATFORM_VISTA_CACHE ||
                      guiMed.getSourcePlatform() == AppConstants.PLATF0RM_CHCS ||
                      guiMed.getSourcePlatform() == AppConstants.PLATF0RM_BHIE))
				{
					def queryMap = [(HttpKeys.RECORD_ID): guiMed.getMedicationId()]
					guiMed.setRecordDetailsToken(
						generateRecordDetailsToken(
							request.patient.getPatientId(),
                            request.patient.getPatientIdSiteCode(),
							"patientPrescriptionFills",
							queryMap,
							guiMed.getSiteCode(),
                            guiMed.getSiteMoniker(),
                            guiMed.getSiteAgency(),
                            guiMed.getSourcePlatform(),
                            guiMed.isSessionCachedRecord()))

                    if (guiMed.isSessionCachedRecord())
                    {
                        //cache outpatient progress note in session
                        def prescriptionFills = []

                        for(GUIPrescriptionFill rxFill : guiMed.getPrescriptionFills())
                        {
                            prescriptionFills.add(BeanUtils.cloneBean(rxFill))
                        }

                        session.appUser.prescriptionFillsMap.put(
                            getCachedRecordKey(guiMed.getRecordDetailsToken()), prescriptionFills)

						//don't send prescription fills as part of response
                        guiMed.setPrescriptionFills(null)
                    }
				}
			}
		}
		
        sendResponse(guiMeds)
    }
}
