/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.OrderDao
import gov.va.med.common.HttpKeys
import gov.va.med.vhahon.common.Utils
import gov.va.med.common.AppConstants

class PatientOrdersController extends BaseController 
{

    def beforeInterceptor = {
        
        if (request.patient == null)
        {
            response.sendError 500
            return false;
        }

        dateRangeCheck();
    }
    
    def show = {
     
        OrderDao orderDao = new OrderDao()

        def guiOrders = orderDao.getPatientOrders(
			session.appUser.provider, 
			request.patient,
			Utils.getCal(request[HttpKeys.START_DATE]),
            Utils.getCal(request[HttpKeys.END_DATE]))
        
		//generate record details token
		if (guiOrders != null)
		{
			for(def guiOrder : guiOrders)
			{
				//chcs does not support order details
				if (guiOrder.getSourcePlatform() != AppConstants.PLATF0RM_CHCS &&
					guiOrder.getOrderId() != null && 
					guiOrder.getOrderId().length() > 0)
				{
					def queryMap = [(HttpKeys.RECORD_ID): guiOrder.getOrderId()]
					guiOrder.setRecordDetailsToken(
						generateRecordDetailsToken(
							request.patient.getPatientId(),
                            request.patient.getPatientIdSiteCode(),
							"patientOrderDetails",
							queryMap,
							guiOrder.getSiteCode(),
                            guiOrder.getSiteMoniker(),
                            guiOrder.getSiteAgency(),
                            guiOrder.getSourcePlatform()))
				}
			}
		}
		
        sendResponse(guiOrders)
    }
}
