/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import java.io.ByteArrayOutputStream
import org.apache.commons.codec.binary.Base64

class PatientNoteDetailBaseController extends BaseController {

	protected void makePDF(String report) {
		report = removeTroublesomeCharacters(report);

		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		baos.write(Base64.decodeBase64(report));  //write pdf blob to OutputStream
		// setting some response headers
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
		response.setHeader("Pragma", "public");
		// setting the content type
		response.setContentType("application/pdf");
		// the content length is needed for MSIE!!!
		response.setContentLength(baos.size());
		// write ByteArrayOutputStream to the ServletOutputStream
		response.outputStream << baos.toByteArray()
	}

	protected void makeRTF(String report) {
		report = removeTroublesomeCharacters(report);

		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		baos.write(Base64.decodeBase64(report));  //write rtf blob to OutputStream
		// setting some response headers
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
		response.setHeader("Pragma", "public");
		// setting the content type
		response.setContentType("application/msword");
		// the content length is needed for MSIE!!!
		response.setContentLength(baos.size());
		// write ByteArrayOutputStream to the ServletOutputStream
		response.outputStream << baos.toByteArray()
	}

	protected void makeCIS_CDAText(String report) {
		report = removeTroublesomeCharacters(report);

		String xml = "";
		String xslPath = resource(dir:'css', file:'CIS_IMPL_CDAR2.xsl')
        int insert = report.lastIndexOf("?>");

        if (insert < 0)
        {
            insert = 0;
        }
        else insert += 2; // skip over last PI


		xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
				"<?xml-stylesheet type=\"text/xsl\" href=\"" + xslPath +"\" ?>" +
				report.substring(insert);

		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		baos.write(xml.getBytes());  //write blob to OutputStream
		// setting some response headers
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
		response.setHeader("Pragma", "public");
		// setting the content type
		response.setContentType("text/xml");
		// the content length is needed for MSIE!!!
		response.setContentLength(baos.size());
		// write ByteArrayOutputStream to the ServletOutputStream
		response.outputStream << baos.toByteArray()
	}

	protected void makeCDAText(String report) {
		report = removeTroublesomeCharacters(report);

		String xml = "";
		String xslPath = resource(dir:'css', file:'CIS_IMPL_CDAR2.xsl')

        int insert = report.lastIndexOf("?>");

        if (insert < 0)
        {
            insert = 0;
        }
        else insert += 2; // skip over last PI

		xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
				"<?xml-stylesheet type=\"text/xsl\" href=\"" + xslPath +"\" ?>" +
				report.substring(insert);

		// setting some response headers
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
		response.setHeader("Pragma", "public");
		// setting the content type
		response.setContentType("text/xml");
		// the content length is needed for MSIE!!!
		response.setContentLength(xml.length());
		
		response.getWriter().print(xml);
	}

	protected static String removeTroublesomeCharacters(String inString) {
		if (inString == null) return null;

		StringBuilder newString = new StringBuilder();
		char ch;

		for (int i = 0; i < inString.length(); i++) {

			ch = inString.charAt(i);
			// remove any characters outside the valid UTF-8 range as well as all control characters
			// except tabs and new lines
			int charVal = ch;

			if(charVal <= 127)
			{
				newString.append(ch);
			}
		}
		return newString.toString();
	}
}
