/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.LabDao
import gov.va.med.common.HttpKeys
import gov.va.med.vhahon.common.Utils

class PatientLabsController extends BaseController 
{

    def beforeInterceptor = {
        
        if (request.patient == null)
        {
            response.sendError 500
            return false;
        }

        dateRangeCheck();
    }
    
    def show = {
     
        LabDao labDao = new LabDao()

        def guiLabs = labDao.getPatientLabs(
			session.appUser.provider, 
			request.patient,
			Utils.getCal(request[HttpKeys.START_DATE]),
            Utils.getCal(request[HttpKeys.END_DATE]))
        
		//generate record details token
		if (guiLabs != null)
		{
			for(def guiLab : guiLabs)
			{
				if (guiLab.getChemId() != null && 
					guiLab.getChemId().length() > 0)
				{
					def queryMap = [ 
						(HttpKeys.LAB_RESULT_CHEMORT): guiLab.getChemORT(),
						(HttpKeys.LAB_RESULT_SUBSCRIPT): guiLab.getSubscript(),
                        (HttpKeys.START_DATE): request[HttpKeys.START_DATE],
                        (HttpKeys.END_DATE): request[HttpKeys.END_DATE]]
					guiLab.setRecordDetailsToken(
						generateRecordDetailsToken(
							request.patient.getPatientId(),
                            request.patient.getPatientIdSiteCode(),
							"patientLabResults",
							queryMap,
							guiLab.getSiteCode(), guiLab.getSiteMoniker(),
                            guiLab.getSiteAgency(), guiLab.getSourcePlatform()))
				}
			}
		}
		
        sendResponse(guiLabs)
    }
}
