/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.LabDao
import gov.va.med.common.HttpKeys

class PatientLabResultsController extends BaseController 
{

    def beforeInterceptor = {
        
        if (request.patient == null || 
            request.recordQuery == null)
        {
            response.sendError 500
            return false;
        }
    }
    
    def show = {
        LabDao labDao = new LabDao()

        def guiLabResults = labDao.getLabOrderResults(
            session.appUser.provider,
            request.patient, 
            request.recordQuery[HttpKeys.LAB_RESULT_CHEMORT],
			request.recordQuery[HttpKeys.LAB_RESULT_SUBSCRIPT],
            request.recordQuery[HttpKeys.RECORD_SITE_CODE])

        for(def guiLabResult : guiLabResults)
        {
            if (guiLabResult.isHistogramAvailable())
            {
                def queryMap = [(HttpKeys.RECORD_ID): guiLabResult.getTestId(),
                                (HttpKeys.START_DATE): request.recordQuery[HttpKeys.START_DATE],
                                (HttpKeys.END_DATE): request.recordQuery[HttpKeys.END_DATE]]
                guiLabResult.setHistogramRecordToken(
                    generateRecordDetailsToken(
                        request.patient.getPatientId(),
                        request.patient.getPatientIdSiteCode(),
                        "patientLabResultHistogram",
                        queryMap,
                        guiLabResult.getSiteCode(),
                        guiLabResult.getSiteMoniker(),
                        guiLabResult.getSiteAgency(),
                        guiLabResult.getSourcePlatform()))
            }
        }

        sendResponse(guiLabResults)
    }
}
