/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.LabDao
import gov.va.med.common.HttpKeys
import gov.va.med.vhahon.common.Utils

class PatientLabResultHistogramController extends BaseController
{

    def beforeInterceptor = {

        if (request.patient == null ||
            request.recordQuery == null)
        {
            response.sendError 500
            return false;
        }
    }

    def show = {
        LabDao labDao = new LabDao()

        def guiHistogramResponse = null;

        guiHistogramResponse = labDao.getLabGraphData(
                    session.appUser.provider,
                    request.patient,
                    request.recordQuery[HttpKeys.RECORD_ID],
                    Utils.getCal(request.recordQuery[HttpKeys.START_DATE]),
                    Utils.getCal(request.recordQuery[HttpKeys.END_DATE]),
                    request.recordQuery[HttpKeys.RECORD_SITE_CODE])

        sendResponse(guiHistogramResponse)
    }
}
