/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.MedicationDao
import gov.va.med.common.HttpKeys
import gov.va.med.vhahon.common.Utils
import gov.va.med.common.AppConstants

class PatientInpatientMedicationsController extends BaseController 
{

    def beforeInterceptor = {
        
        if (request.patient == null)
        {
            response.sendError 500
            return false;
        }

        dateRangeCheck();
    }
    
    def show = {
     
        MedicationDao medicationDao = new MedicationDao()

        def guiMeds = medicationDao.getPatientMedications(
			session.appUser.provider, 
			request.patient,
			MedicationDao.MEDICATION_STATUS_INPATIENT,
			Utils.getCal(request[HttpKeys.START_DATE]),
            Utils.getCal(request[HttpKeys.END_DATE]))
        
		//generate record details token
		if (guiMeds != null)
		{
			for(def guiMed : guiMeds)
			{
				if (guiMed.getMedicationId() != null && 
					guiMed.getMedicationId().length() > 0 &&
                    //currently inpatient medication details only supported by vista cache
                    guiMed.getSourcePlatform() == AppConstants.PLATFORM_VISTA_CACHE)
				{
					def queryMap = [(HttpKeys.RECORD_ID): guiMed.getMedicationId()]
					guiMed.setRecordDetailsToken(
						generateRecordDetailsToken(
							request.patient.getPatientId(),
                            request.patient.getPatientIdSiteCode(),
							"patientInpatientMedicationDetails",
							queryMap,
							guiMed.getSiteCode(),
                            guiMed.getSiteMoniker(),
                            guiMed.getSiteAgency(),
                            guiMed.getSourcePlatform()))
				}
			}
		}
		
        sendResponse(guiMeds)
    }
}
