/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.NoteDao
import gov.va.med.common.HttpKeys
import gov.va.med.common.AppConstants

class PatientDischargeSummaryDetailsController extends PatientNoteDetailBaseController
{

	def beforeInterceptor = {

		if (request.patient == null ||
		request.recordQuery == null) {
			response.sendError 500
			return false;
		}
	}

	def show = {
		NoteDao noteDao = new NoteDao()

		def guiNote = null

		if (request.isSessionCachedRecord) {
			guiNote = session.appUser.inpatientNotesMap.get(
					getCachedRecordKey(params[HttpKeys.RECORD_DETAILS_TOKEN]))
		}
		else {
			guiNote = noteDao.getProgressNote(
					session.appUser.provider,
					request.patient,
					request.recordQuery[HttpKeys.RECORD_ID],
					request.recordQuery[HttpKeys.RECORD_SITE_CODE],
                    request.recordQuery[HttpKeys.RECORD_SITE_MONIKER],
                    request.recordQuery[HttpKeys.RECORD_SITE_AGENCY],
                    request.recordQuery[HttpKeys.RECORD_SOURCE_PLATFORM])
		}

		//if chcs, bhie, or share note
		if (guiNote != null &&
                (request.recordQuery[HttpKeys.RECORD_SOURCE_PLATFORM] == AppConstants.PLATF0RM_CHCS ||
                 request.recordQuery[HttpKeys.RECORD_SOURCE_PLATFORM] == AppConstants.PLATF0RM_SHARE))
		{
			String recordId = request.recordQuery[HttpKeys.RECORD_ID]

            String essentrisNoteId = null;

            if (request.recordQuery[HttpKeys.RECORD_SOURCE_PLATFORM] == AppConstants.PLATF0RM_SHARE)
            {
                essentrisNoteId = recordId.substring("cached:".length());
            }

			String format = guiNote.getStatus();

			if (essentrisNoteId != null && format != null &&
                    format.length() > 0 && !format.contains("text") && !format.contains("TEXT"))
			{
				//pull up essentris note
				String noteText = noteDao.getEssentrisNote(
					session.appUser.provider,
					request.patient,
					essentrisNoteId, 
					format).getNoteText()

                if ("CDA".equalsIgnoreCase(format))
				{
					makeCIS_CDAText(noteText)
					return true
				}
				else
				{
					makePDF(noteText)
					return true
				}
			}
            else if (format != null && format.contains("text") || format.contains("Text") ||
                    format.contains("Text") || format.contains("TXT"))
            {
				String noteText = guiNote.getImages()
				makeCDAText(noteText)
				return true
			}
		}

		sendResponse(guiNote)
	}
}
