/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.dao.ProviderDao
import gov.va.med.groovy.user.AppUser
import gov.va.med.common.AESCryptoUtil

class AuthenticateController extends BaseController
{
    def login = {LoginCommand loginCmd ->
        
        if (request.method == "POST")
        {
            if (!loginCmd.hasErrors())
            {
                String errorText = "Failed to Login - Error contacting the server.<br>Please notify the system administrator";

                try
                {
                    def providerDao = new ProviderDao()
                    def provider = providerDao.login(loginCmd.siteCode, loginCmd.accessCode, loginCmd.verifyCode)

                    //check if there was a problem logging in provider
                    if (provider == null ||
                        provider.getUserId() == null ||
                        provider.getUserId().length() < 1 ||
                        provider.getUserId().contains("^"))
                    {
                        if (provider != null && provider.getUserId() != null)
                        {
                            String providerId = provider.getUserId();

                            if (providerId.contains("^"))
                            {
                                errorText = providerId.substring(providerId.indexOf("^")+1)
                            }
                        }

                        render(view:"login", model:[errorText:errorText, grailsConfig:grailsApplication.config.grails])
                    }
                    else
                    {

                        def cfg = provider.getCfg();
                        AppUser appUser = new AppUser(provider:provider,
                            securityKey:AESCryptoUtil.generateSecurityKey(),cfg:cfg)
                        session.appUser = appUser

                        redirect(controller:'app')
                    }
                }
                catch (Exception e)
                {
                    log.error("AuthenticateController::login", e)

                    render(view:"login", model:[errorText:errorText, grailsConfig:grailsApplication.config.grails])
                }
            }
            else
            {
                render(view:"login", model:[loginCmd:loginCmd, grailsConfig:grailsApplication.config.grails])
            }
        }

        [grailsConfig:grailsApplication.config.grails]
    }

    def logout = {
        session.invalidate()
    }
}

class LoginCommand
{
    String siteCode
    String accessCode
    String verifyCode

    static constraints = {
        siteCode blank:false
        accessCode blank:false
        verifyCode blank:false
    }
}