/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails
import grails.converters.*

class AppController extends BaseController 
{

    def index = {

        def siteIcon = "VA"
        def cfg = session.appUser.cfg
        def theme = "default"
        def jsonCfg = ""
        if (cfg != null && cfg.length() > 0)  {
            jsonCfg = JSON.parse(cfg)
            for (item in jsonCfg){
                if (item.cfgItem == "UI_CONF"){
                    for(option in item.options){
                        if(option.theme){
                            theme = option.theme
                        }
                    }
                }
            }
        }
        if (session.appUser.provider.getLoginSiteCode() == grailsApplication.config.grails.localSiteCodeDOD)
        {
            siteIcon = "DOD"
        }

        [providerName:session.appUser.provider.getName(), theme:theme, siteIcon:siteIcon, grailsConfig:grailsApplication.config.grails, appVersion:grailsApplication.metadata['app.version'],cfg:cfg,theme:theme]
	}
}
