/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package janusgrails

import gov.va.med.common.HttpKeys
import gov.va.med.dao.NoteDao
import gov.va.med.vhahon.common.Utils
import org.apache.commons.beanutils.BeanUtils
import gov.va.med.jmeadows.webservice.ProgressNote

class AddNoteController extends BaseController
{

    def beforeInterceptor = {
        
        if (request.patient == null)
        {
            response.sendError 500
            return false;
        }

    }
    
    def save = {
                
        NoteDao noteDao = new NoteDao()
        ProgressNote progressNote = new ProgressNote();
        progressNote.setNoteText(params['noteText']);
        progressNote.setLocation(params['noteClinicId']);
        progressNote.setNoteTitleId(params['noteTitleId']);

        def result = noteDao.addNote(
            session.appUser.provider,
            request.patient, 
            progressNote,
            params['noteSig'])

        if (result=="Success") {
            response.status = 200
            render "The note was added successfuly."
        }
        else {
            response.status = 500
            render "Could not add this note. An error was detected: ${result} "
        }
        //sendResponse(result)
    }


}

