--
-- Copyright (C) 2012 KRM Associates, Inc. healtheme@krminc.com
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--         http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--

USE phr;

-- setup patient manager/admin accounts
-- note: if using test data do not add more users to system via this script
--       user data relies on john doe having user_id=3, adding more users here would break that
INSERT INTO `phr`.`user_users`
    (username, password, requires_reset,
        title, first_name, middle_name, last_name, suffix, preferred_name,email,date_created)
VALUES
    ('usermanager', '2c344bec48cf22b8fb572059541092cac56c12ee1e66c1c87a865109c2dead25a095a0483611e3b21deb31669cce9ba18d1f4893aaf4d1cedfce59abb5de25e0', 0,
        NULL, 'User', 'A', 'Manager', NULL, 'UM','usermanager@example.com',CURRENT_TIMESTAMP),
    ('admin', 'c7ad44cbad762a5da0a452f9e854fdc1e0e7a52a38015f23f3eab1d80b931dd472634dfac71cd34ebc35d16ab7fb8a90c81f975113d6c7538dc69dd8de9077ec', 0,
        NULL, 'Admin', 'A', 'Strator', NULL, 'Admin','admin@example.com',CURRENT_TIMESTAMP),
    ('caretaker', 'e2318676a2af6d90445741a1fb5a0ceb4a7e0ec87f99db784abaac8c1efd90ac7d530c0ae73ace75171b6e1e498f6499fc990595470445d2a76ad439dcd3e264', 0,
        NULL, 'Care', 'A', 'Taker', NULL, 'CC','caretaker@example.com',CURRENT_TIMESTAMP);

INSERT INTO `phr`.`user_roles`
    (username, role, date_created)
VALUES
    ('usermanager', 'ROLE_PATIENTADMIN', CURRENT_TIMESTAMP),
    ('admin', 'ROLE_ADMIN', CURRENT_TIMESTAMP),
    ('caretaker', 'ROLE_CARETAKER', CURRENT_TIMESTAMP);

INSERT INTO `phr`.`user_addresses`
    (user_id, primary_address, created_by_user_id)
VALUES
    (1, 1, 1), -- usermanager
    (2, 1, 1), -- admin
    (3, 1, 1); -- caretaker

INSERT INTO `phr`.`system_data_sources`
    (data_source_name, description, data_type, modifiable, date_added, notes)
VALUES
    ('Self Entered', NULL, NULL, true, CURRENT_DATE, NULL);


INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Mountain Bicycling', 1, 'bicycling', 'bicycling, BMX or mountain', '01009', '8.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'bicycling', 'bicycling, <10 mph, leisure, to work or for pleasure (Taylor Code 115)', '01010', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Bicycling', 1, 'bicycling', 'bicycling, general', '01015', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'bicycling', 'bicycling, 10-11.9 mph, leisure, slow, light effort', '01020', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'bicycling', 'bicycling, 12-13.9 mph, leisure, moderate effort', '01030', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'bicycling', 'bicycling, 14-15.9 mph, racing or leisure, fast, vigorous effor', '01040', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'bicycling', 'bicycling, 16-19 mph, racing/not drafting or >19 mph drafting, very fast, racing genera', '01050', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'bicycling', 'bicycling, >20 mph, racing, not drafting', '01060', '16');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Unicycling', 1, 'bicycling', 'unicycling', '01070', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise bicycling, stationary, general', '02010', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Stationary Bicycling', 1, 'conditioning', 'exercise bicycling, stationary, 50 watts, very light effor', '02011', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise bicycling, stationary, 100 watts, light effor', '02012', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise bicycling, stationary, 150 watts, moderate effor', '02013', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise bicycling, stationary, 200 watts, vigorous effor', '02014', '10.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise bicycling, stationary, 250 watts, very vigorous effor', '02015', '12.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Calisthenics', 1, 'conditioning', 'exercise calisthenics (e.g. pushups, situps, pullups, jumping jacks), heavy, vigorous effort', '02020', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise calisthenics, home exercise, light or moderate effort, general (example: back exercises), going up & down from floor (Taylor Code 150', '02030', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Circuit Training', 1, 'conditioning', 'exercise circuit training, including some aerobic movement with minimal rest, general', '02040', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise weight lifting (free weight, nautilus or universal-type), power lifting or body building, vigorous effort (Taylor Code 210', '02050', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise health club exercise, general (Taylor Code 160', '02060', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise stair-treadmill ergometer, general', '02065', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Rowing Machine', 1, 'conditioning', 'exercise rowing, stationary ergometer, genera', '02070', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise rowing, stationary, 50 watts, light effort', '02071', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise rowing, stationary, 100 watts, moderate effor', '02072', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise rowing, stationary, 150 watts, vigorous effor', '02073', '8.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise rowing, stationary, 200 watts, very vigorous effor', '02074', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Ski Machine', 1, 'conditioning', 'exercise ski machine, general', '02080', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Jazzercise', 1, 'conditioning', 'exercise slimnastics, jazzercise', '02090', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Yoga', 1, 'conditioning', 'exercise stretching, hatha yoga', '02100', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Stretching', 1, 'conditioning', 'exercise mild stretching', '02101', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise teaching aerobic exercise class', '02110', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Water Aerobics', 1, 'conditioning', 'exercise water aerobics, water calisthenics', '02120', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Weight Lifting', 1, 'conditioning', 'exercise weight lifting (free, nautilus or universal-type), light or moderate effort, light workout, general.', '02130', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'conditioning', 'exercise whirlpool, sitting', '02135', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Ballet or Modern Dance', 1, 'dancing', 'ballet or modern, twist, jazz, tap, jitterbug', '03010', '4.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Aerobic Dance', 1, 'dancing', 'aerobic, general', '03015', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'dancing', 'aerobic, step, with 6 � 8 inch step', '03016', '8.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'dancing', 'aerobic, step, with 10 � 12 inch step', '03017', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'dancing', 'aerobic, low impact', '03020', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'dancing', 'aerobic, high impact', '03021', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Dance', 1, 'dancing', 'general, Greek, Middle Eastern, hula, flamenco, belly, and swing dancing', '03025', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'dancing', 'ballroom, dancing fast (Taylor Code 125)', '03030', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'dancing', 'ballroom, fast (disco, folk, square), line dancing, Irish step dancing, polka, contra, country', '03031', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Ballroom Dance', 1, 'dancing', 'ballroom, slow (e.g. waltz, foxtrot, slow dancing), samba, tango, 19th C, mambo, chacha', '03040', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'dancing', 'Anishinaabe Jingle Dancing or other traditional American Indian dancing', '03050', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Fishing', 1, 'fishing and hunting', 'fishing, general', '04001', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'digging worms, with shovel', '04010', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'fishing from river bank and walking', '04020', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'fishing from boat, sitting', '04030', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'fishing from river bank, standing (Taylor Code 660)', '04040', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'fishing in stream, in waders (Taylor Code 670)', '04050', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'fishing, ice, sitting', '04060', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'hunting, bow and arrow or crossbow', '04070', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'hunting, deer, elk, large game (Taylor Code 170)', '04080', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'hunting, duck, wading', '04090', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Hunting', 1, 'fishing and hunting', 'hunting, general', '04100', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'hunting, pheasants or grouse (Taylor Code 680', '04110', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'hunting, rabbit, squirrel, prairie chick, raccoon, small game (Taylor Code 690)', '04120', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'fishing and hunting', 'pistol shooting or trap shooting, standing', '04130', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Sweeping', 1, 'home activities', 'carpet sweeping, sweeping floors', '05010', '3.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'cleaning, heavy or major (e.g. wash car, wash windows, clean garage), vigorous effor', '05020', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Mopping', 1, 'home activities', 'mopping', '05021', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'multiple household tasks all at once, light effor', '05025', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'multiple household tasks all at once, moderate effor', '05026', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'multiple household tasks all at once, vigorous effor', '05027', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Home Cleaning', 1, 'home activities', 'cleaning, house or cabin, genera', '05030', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'cleaning, light (dusting, straightening up, changing linen, carrying out trash', '05040', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Dish Washing', 1, 'home activities', 'wash dishes - standing or in general (not broken into stand/walk components', '05041', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'wash dishes; clearing dishes from table � walking', '05042', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Vacuuming', 1, 'home activities', 'vacuuming', '05043', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'butchering animals', '05045', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'cooking or food preparation - standing or sitting or in general (not broken into stand/walk components), manual appliance', '05050', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'serving food, setting table - implied walking or standing', '05051', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'cooking or food preparation - walking', '05052', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'feeding animals', '05053', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'putting away groceries (e.g. carrying groceries, shopping without a grocery cart), carrying packages', '05055', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'carrying groceries upstairs', '05056', '7.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'cooking Indian bread on an outside stove', '05057', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'food shopping with or without a grocery cart, standing or walking', '05060', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'non-food shopping, standing or walking', '05065', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Shopping', 1, 'home activities', 'walking shopping (non-grocery shopping)', '05066', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Ironing', 1, 'home activities', 'ironing', '05070', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'sitting - knitting, sewing, lt. wrapping (presents)', '05080', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'implied standing - laundry, fold or hang clothes, put clothes in washer or dryer, packing suitcase', '05090', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'implied walking - putting away clothes, gathering clothes to pack, putting away laundry', '05095', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'making bed', '05100', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'maple syruping/sugar bushing (including carrying buckets, carrying wood)', '05110', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Moving Furniture', 1, 'home activities', 'moving furniture, household items, carrying boxes', '05120', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Scrubbing Floors', 1, 'home activities', 'scrubbing floors, on hands and knees, scrubbing bathroom, bathtub', '05130', '3.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'sweeping garage, sidewalk or outside of house', '05140', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'moving household items, carrying boxes', '05145', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'standing - packing/unpacking boxes, occasional lifting of household items light - moderate effor', '05146', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'implied walking - putting away household items - moderate effort', '05147', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Watering Plants', 1, 'home activities', 'watering plants', '05148', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'building a fire inside', '05149', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'moving household items upstairs, carrying boxes or furniture', '05150', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'standing - light (pump gas, change light bulb, etc.)', '05160', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'walking - light, non-cleaning (readying to leave, shut/lock doors, close windows, etc.', '05165', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'sitting - playing with child(ren) � light, only active periods', '05170', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'standing - playing with child(ren) � light, only active periods', '05171', '2.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Playing with Children', 1, 'home activities', 'walk/run - playing with child(ren) � moderate, only active periods', '05175', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'walk/run - playing with child(ren) � vigorous, only active periods', '05180', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'carrying small children', '05181', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'child care: sitting/kneeling - dressing, bathing, grooming, feeding, occasional lifting of child-light effort, genera', '05185', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'child care: standing - dressing, bathing, grooming, feeding, occasional lifting of child-light effort', '05186', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'elder care, disabled adult, only active periods', '05187', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'reclining with baby', '05188', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'sit, playing with animals, light, only active periods', '05190', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'stand, playing with animals, light, only active periods', '05191', '2.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'walk/run, playing with animals, light, only active periods', '05192', '2.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Playing with Animals', 1, 'home activities', 'walk/run, playing with animals, moderate, only active periods', '05193', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'walk/run, playing with animals, vigorous, only active periods', '05194', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home activities', 'standing - bathing dog', '05195', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'airplane repair', '06010', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'automobile body work', '06020', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Automobile Repair', 1, 'home repair', 'automobile repair', '06030', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Carpentry', 1, 'home repair', 'carpentry, general, workshop (Taylor Code 620)', '06040', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'carpentry, outside house, installing rain gutters, building a fence, (Taylor Code 640)', '06050', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'carpentry, finishing or refinishing cabinets or furniture', '06060', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'carpentry, sawing hardwood', '06070', '7.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'caulking, chinking log cabin', '06080', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'caulking, except log cabin', '06090', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Cleaning Gutters', 1, 'home repair', 'cleaning gutters', '06100', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'excavating garage', '06110', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'hanging storm windows', '06120', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Laying Carpet', 1, 'home repair', 'laying or removing carpet', '06130', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'laying tile or linoleum, repairing appliances', '06140', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'painting, outside home (Taylor Code 650)', '06150', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'painting, papering, plastering, scraping, inside house, hanging sheet rock, remodeling', '06160', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Painting Home', 1, 'home repair', 'painting, (Taylor Code 630)', '06165', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'put on and removal of tarp - sailboat', '06170', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Roofing', 1, 'home repair', 'roofing', '06180', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'sanding floors with a power sander', '06190', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'scraping and painting sailboat or powerboat', '06200', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'spreading dirt with a shovel', '06210', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Automobile Washing', 1, 'home repair', 'washing and waxing hull of sailboat, car, powerboat, airplane', '06220', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'home repair', 'washing fence, painting fence', '06230', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Plumbing', 1, 'home repair', 'wiring, plumbing', '06240', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'inactivity', 'quiet lying quietly, watching television', '07010', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'inactivity', 'quiet lying quietly, doing nothing, lying in bed awake, listening to music (not talking or reading', '07011', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'inactivity', 'quiet sitting quietly and watching television', '07020', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'inactivity', 'quiet sitting quietly, sitting smoking, listening to music (not talking or reading), watching a movie in a theate', '07021', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'inactivity', 'quiet sleeping', '07030', '0.9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'inactivity', 'quiet standing quietly (standing in a line)', '07040', '1.2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'inactivity', 'light reclining - writing', '07050', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'inactivity', 'light reclining - talking or talking on phone', '07060', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'inactivity', 'light reclining - reading', '07070', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'inactivity', 'light meditating', '07075', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'carrying, loading or stacking wood, loading/unloading or carrying lumber', '08010', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Chopping Wood', 1, 'lawn and garden', 'chopping wood, splitting logs', '08020', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'clearing land, hauling branches, wheelbarrow chores', '08030', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'digging sandbox', '08040', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'digging, spading, filling garden, composting, (Taylor Code 590)', '08050', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'gardening with heavy power tools, tilling a garden, chain saw', '08060', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'laying crushed rock', '08080', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'laying sod', '08090', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Mowing Lawn', 1, 'lawn and garden', 'mowing lawn, general', '08095', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'mowing lawn, riding mower (Taylor Code 550)', '08100', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'mowing lawn, walk, hand mower (Taylor Code 570)', '08110', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'mowing lawn, walk, power mower', '08120', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'mowing lawn, power mower (Taylor Code 590)', '08125', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Blowing Snow', 1, 'lawn and garden', 'operating snow blower, walking', '08130', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'planting seedlings, shrubs', '08140', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'planting trees', '08150', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'raking lawn', '08160', '4.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'raking lawn (Taylor Code 600)', '08165', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'raking roof with snow rake', '08170', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'riding snow blower', '08180', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'sacking grass, leaves', '08190', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'shoveling snow, by hand (Taylor Code 610)', '08200', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'trimming shrubs or trees, manual cutter', '08210', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'trimming shrubs or trees, power cutter, using leaf blower, edger', '08215', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'walking, applying fertilizer or seeding a lawn', '08220', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'watering lawn or garden, standing or walking', '08230', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'weeding, cultivating garden (Taylor Code 580)', '08240', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Gardening', 1, 'lawn and garden', 'gardening, general', '08245', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'picking fruit off trees, picking fruits/vegetables, moderate effort', '08246', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'implied walking/standing - picking up yard, light, picking flowers or vegetables', '08250', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'lawn and garden', 'walking, gathering gardening tools', '08251', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'sitting - card playing, playing board games', '09010', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'standing - drawing (writing), casino gambling, duplicating machine', '09020', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'sitting - reading, book, newspaper, etc.', '09030', '1.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'sitting - writing, desk work, typing', '09040', '1.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'standing - talking or talking on the phone', '09050', '1.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'sitting - talking or talking on the phone', '09055', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'sitting - studying, general, including reading and/or writing', '09060', '1.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'sitting - in class, general, including note-taking or class discussion', '09065', '1.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'standing - reading', '09070', '1.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'standing - miscellaneous', '09071', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'sitting - arts and crafts, light effort', '09075', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'sitting - arts and crafts, moderate effort', '09080', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'standing - arts and crafts, light effort', '09085', '1.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'standing - arts and crafts, moderate effort', '09090', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'standing - arts and crafts, vigorous effort', '09095', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'retreat/family reunion activities involving sitting, relaxing, talking, eating', '09100', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'touring/traveling/vacation involving walking and riding', '09105', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Camping', 1, 'miscellaneous', 'camping involving standing, walking, sitting, light-to-moderate effort', '09110', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'miscellaneous', 'sitting at a sporting event, spectator', '09115', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'accordion', '10010', '1.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'cello', '10020', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'conducting', '10030', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'drums', '10040', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'flute (sitting)', '10050', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'horn', '10060', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'piano or organ', '10070', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'trombone', '10080', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'trumpet', '10090', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'violin', '10100', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'woodwind', '10110', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'guitar, classical, folk (sitting)', '10120', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'guitar, rock and roll band (standing)', '10125', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'marching band, playing an instrument, baton twirling (walking)', '10130', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'music playing', 'marching band, drum major (walking)', '10135', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'bakery, general, moderate effort', '11010', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'bakery, light effort', '11015', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'bookbinding', '11020', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'building road (including hauling debris, driving heavy machinery)', '11030', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'building road, directing traffic (standing)', '11035', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'carpentry, general', '11040', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'carrying heavy loads, such as bricks', '11050', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'carrying moderate loads up stairs, moving boxes (16-40 pounds)', '11060', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'chambermaid, making bed (nursing)', '11070', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'coal mining, drilling coal, rock', '11080', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'coal mining, erecting supports', '11090', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Coal Mining', 1, 'occupation', 'coal mining, general', '11100', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'coal mining, shoveling coal', '11110', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'construction, outside, remodeling', '11120', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'custodial work - buffing the floor with electric buffer', '11121', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'custodial work - cleaning sink and toilet, light effort', '11122', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'custodial work - dusting, light effort', '11123', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'custodial work � feathering arena floor, moderate effor', '11124', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'custodial work - general cleaning, moderate effort', '11125', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'custodial work - mopping, moderate effort', '11126', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'custodial work - take out trash, moderate effor', '11127', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'custodial work - vacuuming, light effort', '11128', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'custodial work - vacuuming, moderate effort', '11129', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'electrical work, plumbing', '11130', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, baling hay, cleaning barn, poultry work, vigorous effort', '11140', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, chasing cattle, non-strenuous (walking), moderate effort', '11150', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, chasing cattle or other livestock on horseback, moderate effor', '11151', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, chasing cattle or other livestock, driving, light effort', '11152', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, driving harvester, cutting hay, irrigation work', '11160', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, driving tractor', '11170', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, feeding small animals', '11180', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, feeding cattle, horses', '11190', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, hauling water for animals, general hauling water', '11191', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, taking care of animals (grooming, brushing, shearing sheep, assisting with birthing, medical care, branding)', '11192', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, forking straw bales, cleaning corral or barn, vigorous effort', '11200', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, milking by hand, moderate effort', '11210', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, milking by machine, light effort', '11220', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'farming, shoveling grain, moderate effort', '11230', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'fire fighter, general', '11240', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'fire fighter, climbing ladder with full gear', '11245', '11');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'fire fighter, hauling hoses on ground', '11246', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, ax chopping, fast', '11250', '17');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, ax chopping, slow', '11260', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, barking trees', '11270', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, carrying logs', '11280', '11');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, felling trees', '11290', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, general', '11300', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, hoeing', '11310', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, planting by hand', '11320', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, sawing by hand', '11330', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, sawing, power', '11340', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, trimming trees', '11350', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'forestry, weeding', '11360', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'furriery', '11370', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'horse grooming', '11380', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'horse racing, galloping', '11390', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'horse racing, trotting', '11400', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'horse racing, walking', '11410', '2.6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'locksmith', '11420', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'machine tooling, machining, working sheet meta', '11430', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'machine tooling, operating lathe', '11440', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'machine tooling, operating punch press', '11450', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'machine tooling, tapping and drilling', '11460', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'machine tooling, welding', '11470', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'masonry, concrete', '11480', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'masseur, masseuse (standing)', '11485', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'moving, pushing heavy objects, 75 lbs or more (desks, moving van work)', '11490', '7.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'skindiving or SCUBA diving as a frogman (Navy Seal)', '11495', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'operating heavy duty equipment/automated, not driving', '11500', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'orange grove work', '11510', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'printing (standing)', '11520', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'police, directing traffic (standing)', '11525', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'police, driving a squad car (sitting)', '11526', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'police, riding in a squad car (sitting)', '11527', '1.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'police, making an arrest (standing)', '11528', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'shoe repair, general', '11530', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'shoveling, digging ditches', '11540', '8.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'shoveling, heavy (more than 16 pounds/minute', '11550', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'shoveling, light (less than 10 pounds/minute)', '11560', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'shoveling, moderate (10 to 15 pounds/minute)', '11570', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'sitting - light office work, general (chemistry lab work, light use of hand tools, watch repair or micro-assembly, light assembly/repair), sitting, reading, driving at work', '11580', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'sitting meetings, general, and/or with talking involved, eatting at a business meeting', '11585', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'sitting; moderate (heavy levers, riding mower/forklift, crane operation) teaching stretching or yoga', '11590', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'standing; light (bartending, store clerk, assembling, filing, duplicating, putting up a Christmas tree), standing and talking at work, changing clothes when teaching physical education', '11600', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'standing; light/moderate (assemble/repair heavy parts, welding, stocking, auto repair, pack boxes for moving, etc.), patient care (as in nursing', '11610', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'lifting items continuously, 10 � 20 lbs, with limited walking or resting', '11615', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'standing; moderate (assembling at fast rate, intermittent, lifting 50 lbs, hitch/twisting ropes)', '11620', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'standing; moderate/heavy (lifting more than 50 lbs, masonry, painting, paper hanging', '11630', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'steel mill, fettling', '11640', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'steel mill, forging', '11650', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'steel mill, hand rolling', '11660', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'steel mill, merchant mill rolling', '11670', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'steel mill, removing slag', '11680', '11');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'steel mill, tending furnace', '11690', '7.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'steel mill, tipping molds', '11700', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'steel mill, working in general', '11710', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'tailoring, cutting', '11720', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'tailoring, general', '11730', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'tailoring, hand sewing', '11740', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'tailoring, machine sewing', '11750', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'tailoring, pressing', '11760', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'tailoring, weaving', '11765', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'truck driving, loading and unloading truck (standing)', '11766', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'typing, electric, manual or computer', '11770', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'using heavy power tools such as pneumatic tools (jackhammers, drills, etc.', '11780', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'using heavy tools (not power) such as shovel, pick, tunnel bar, spade', '11790', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking on job, less than 2.0 mph (in office or lab area), very slow', '11791', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking on job, 3.0 mph, in office, moderate speed, not carrying anything', '11792', '3.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking on job, 3.5 mph, in office, brisk speed, not carrying anything', '11793', '3.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking, 2.5 mph, slowly and carrying light objects less than 25 pounds', '11795', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking, gathering things at work, ready to leave', '11796', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking, 3.0 mph, moderately and carrying light objects less than 25 lbs', '11800', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking, pushing a wheelchair', '11805', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking, 3.5 mph, briskly and carrying objects less than 25 pounds', '11810', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking or walk downstairs or standing, carrying objects about 25 to 49 pounds', '11820', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking or walk downstairs or standing, carrying objects about 50 to 74 pounds', '11830', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking or walk downstairs or standing, carrying objects about 75 to 99 pounds', '11840', '7.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'walking or walk downstairs or standing, carrying objects about 100 pounds or ove', '11850', '8.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'working in scene shop, theater actor, backstage employee', '11870', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'teach physical education, exercise, sports classes (non-sport play', '11875', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'occupation', 'teach physical education, exercise, sports classes (participate in the class', '11876', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'jog/walk combination (jogging component of less than 10 minutes) (Taylor Code 180', '12010', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Jogging', 1, 'running', 'jogging, general', '12020', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'jogging, in place', '12025', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'jogging on a mini-tramp', '12027', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 5 mph (12 min/mile)', '12030', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 5.2 mph (11.5 min/mile)', '12040', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 6 mph (10 min/mile)', '12050', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 6.7 mph (9 min/mile)', '12060', '11');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 7 mph (8.5 min/mile)', '12070', '11.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 7.5 mph (8 min/mile)', '12080', '12.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 8 mph (7.5 min/mile)', '12090', '13.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 8.6 mph (7 min/mile)', '12100', '14');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 9 mph (6.5 min/mile)', '12110', '15');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 10 mph (6 min/mile)', '12120', '16');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, 10.9 mph (5.5 min/mile)', '12130', '18');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Cross Country Running', 1, 'running', 'running, cross country', '12140', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running (Taylor Code 200)', '12150', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Running', 1, 'running', 'running, in place', '12160', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, stairs, up', '12170', '15');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, on a track, team practice', '12180', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, training, pushing a wheelchair', '12190', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'running', 'running, wheeling, general', '12195', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'standing - getting ready for bed, in general', '13000', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'sitting on toilet', '13009', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'bathing (sitting)', '13010', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'dressing, undressing (standing or sitting)', '13020', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'eating (sitting)', '13030', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'talking and eating or eating only (standing)', '13035', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'taking medication, sitting or standing', '13036', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'grooming (washing, shaving, brushing teeth, urinating, washing hands, putting on make-up), sitting or standing', '13040', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'hairstyling', '13045', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'having hair or nails done by someone else, sitting', '13046', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'self care', 'showering, toweling off (standing)', '13050', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sexual activity', 'active, vigorous effort', '14010', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Sexual Activity', 1, 'sexual activity', 'general, moderate effort', '14020', '1.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sexual activity', 'passive, light effort, kissing, hugging', '14030', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Archery', 1, 'sports', 'archery (non-hunting)', '15010', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'badminton, competitive (Taylor Code 450)', '15020', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Badminton', 1, 'sports', 'badminton, social singles and doubles, general', '15030', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'basketball, game (Taylor Code 490)', '15040', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Basketball', 1, 'sports', 'basketball, non-game, general (Taylor Code 480)', '15050', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'basketball, officiating (Taylor Code 500)', '15060', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'basketball, shooting baskets', '15070', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'basketball, wheelchair', '15075', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Billiards', 1, 'sports', 'billiards', '15080', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Bowling', 1, 'sports', 'bowling (Taylor Code 390)', '15090', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Boxing', 1, 'sports', 'boxing, in ring, general', '15100', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'boxing, punching bag', '15110', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'boxing, sparring', '15120', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Broomball', 1, 'sports', 'broomball', '15130', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Dodgeball', 1, 'sports', 'children�s games (hopscotch, 4-square, dodge ball, playground apparatus, t-ball, tetherball, marbles, jacks, acrace games', '15135', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Coaching Sports', 1, 'sports', 'coaching: football, soccer, basketball, baseball, swimming, etc.', '15140', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Cricket', 1, 'sports', 'cricket (batting, bowling)', '15150', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Croquet', 1, 'sports', 'croquet', '15160', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Curling', 1, 'sports', 'curling', '15170', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Darts', 1, 'sports', 'darts, wall or lawn', '15180', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Drag Racing', 1, 'sports', 'drag racing, pushing or driving a car', '15190', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Fencing', 0, 'sports', 'fencing', '15200', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'football, competitive', '15210', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Football', 1, 'sports', 'football, touch, flag, general (Taylor Code 510', '15230', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'football or baseball, playing catch', '15235', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Frisbee', 1, 'sports', 'frisbee playing, general', '15240', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Ultimate Frisbee', 1, 'sports', 'frisbee, ultimate', '15250', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Golf', 1, 'sports', 'golf, general', '15255', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'golf carrying clubs', '15260', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'golf, walking and carrying clubs (See footnote at end of the Compendium', '15265', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Miniature Golf', 1, 'sports', 'golf, miniature, driving range', '15270', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'golf, pulling clubs', '15280', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'golf, walking and pulling clubs (See footnote at end of the Compendium', '15285', '4.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'golf, using power cart (Taylor Code 070)', '15290', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Gymnastics', 1, 'sports', 'gymnastics, general', '15300', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Hacky Sack', 1, 'sports', 'hacky sack', '15310', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Handball', 1, 'sports', 'handball, general (Taylor Code 520)', '15320', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'handball, team', '15330', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Hang Gliding', 1, 'sports', 'hang gliding', '15340', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Field Hockey', 1, 'sports', 'hockey, field', '15350', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Ice Hockey', 1, 'sports', 'hockey, ice', '15360', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Horseback Riding', 1, 'sports', 'horseback riding, general', '15370', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'horseback riding, saddling horse, grooming horse', '15380', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'horseback riding, trotting', '15390', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'horseback riding, walking', '15400', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'horseshoe pitching, quoits', '15410', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Jai Alai', 1, 'sports', 'jai alai', '15420', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Martial Arts', 1, 'sports', 'judo, jujitsu, karate, kick boxing, tae kwan do', '15430', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Juggling', 1, 'sports', 'juggling', '15440', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Kickball', 1, 'sports', 'kickball', '15450', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Lacrosse', 1, 'sports', 'lacrosse', '15460', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Motor-Cross', 1, 'sports', 'motor-cross', '15470', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Orienteering', 1, 'sports', 'orienteering', '15480', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'paddleball, competitive', '15490', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Paddleball', 1, 'sports', 'paddleball, casual, general (Taylor Code 460)', '15500', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Polo', 1, 'sports', 'polo', '15510', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'racquetball, competitive', '15520', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Racquetball', 1, 'sports', 'racquetball, casual, general (Taylor Code 470)', '15530', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Rock Climbing', 1, 'sports', 'rock climbing, ascending rock', '15535', '11');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Rapelling', 1, 'sports', 'rock climbing, rappelling', '15540', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'rope jumping, fast', '15550', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Jump Rope', 1, 'sports', 'rope jumping, moderate, general', '15551', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'rope jumping, slow', '15552', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Rugby', 1, 'sports', 'rugby', '15560', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Shuffleboard', 1, 'sports', 'shuffleboard, lawn bowling', '15570', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Skateboarding', 1, 'sports', 'skateboarding', '15580', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Roller Skating', 1, 'sports', 'skating, roller (Taylor Code 360)', '15590', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Roller Blading', 1, 'sports', 'roller blading (in-line skating)', '15591', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Sky Diving', 1, 'sports', 'sky diving', '15600', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'soccer, competitive', '15605', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Soccer', 1, 'sports', 'soccer, casual, general (Taylor Code 540)', '15610', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Baseball/Softball', 1, 'sports', 'softball or baseball, fast or slow pitch, general (Taylor Code 440)', '15620', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'softball, officiating', '15630', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'softball, pitching', '15640', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Squash', 1, 'sports', 'squash (Taylor Code 530)', '15650', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Table Tennis', 1, 'sports', 'table tennis, ping pong (Taylor Code 410)', '15660', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Tai Chi', 1, 'sports', 'tai chi', '15670', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Tennis', 1, 'sports', 'tennis, general', '15675', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'tennis, doubles (Taylor Code 430)', '15680', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'tennis, doubles', '15685', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'tennis, singles (Taylor Code 420)', '15690', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Trampolining', 1, 'sports', 'trampoline', '15700', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'volleyball (Taylor Code 400)', '15710', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'sports', 'volleyball, competitive, in gymnasium', '15711', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Volleyball', 1, 'sports', 'volleyball, non-competitive, 6 - 9 member team, general.', '15720', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Beach Volleyball', 1, 'sports', 'volleyball, beach', '15725', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Wrestling', 1, 'sports', 'wrestling (one match = 5 minutes)', '15730', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Wallyball', 1, 'sports', 'wallyball, general', '15731', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Track and Field - Throwing', 1, 'sports', 'track and field (shot, discus, hammer throw)', '15732', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Track and Field - Jumping', 1, 'sports', 'track and field (high jump, long jump, triple jump, javelin, pole vault)', '15733', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Track and Field - Hurdles', 1, 'sports', 'track and field (steeplechase, hurdles)', '15734', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'transportation', 'automobile or light truck (not a semi) driving', '16010', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'transportation', 'riding in a car or truck', '16015', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'transportation', 'riding in a bus', '16016', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'transportation', 'flying airplane', '16020', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'transportation', 'motor scooter, motorcycle', '16030', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'transportation', 'pushing plane in and out of hangar', '16040', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'transportation', 'driving heavy truck, tractor, bus', '16050', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Backpacking', 1, 'walking', 'backpacking (Taylor Code 050)', '17010', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'carrying infant or 15 pound load (e.g. suitcase), level ground or downstairs', '17020', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'carrying load upstairs, general', '17025', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'carrying 1 to 15 lb load, upstairs', '17026', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'carrying 16 to 24 lb load, upstairs', '17027', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'carrying 25 to 49 lb load, upstairs', '17028', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'carrying 50 to 74 lb load, upstairs', '17029', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'carrying 74+ lb load, upstairs', '17030', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'loading /unloading a car', '17031', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'climbing hills with 0 to 9 pound load', '17035', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'climbing hills with 10 to 20 pound load', '17040', '7.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'climbing hills with 21 to 42 pound load', '17050', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'climbing hills with 42+ pound load', '17060', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'downstairs', '17070', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Hiking', 1, 'walking', 'hiking, cross country (Taylor Code 040)', '17080', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Bird Watching', 1, 'walking', 'bird watching', '17085', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Marching', 1, 'walking', 'marching, rapidly, military', '17090', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'pushing or pulling stroller with child or walking with children', '17100', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'pushing a wheelchair, non-occupational setting', '17105', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'race walking', '17110', '6.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'rock or mountain climbing (Taylor Code 060)', '17120', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'up stairs, using or climbing up ladder (Taylor Code 030)', '17130', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'using crutches', '17140', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, household walking', '17150', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, less than 2.0 mph, level ground, strolling, very slow', '17151', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, 2.0 mph, level, slow pace, firm surface', '17152', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking for pleasure (Taylor Code 010)', '17160', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking from house to car or bus, from car or bus to go places, from car or bus to and from the worksite', '17161', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking to neighbor�s house or family�s house for social reasons', '17162', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking the dog', '17165', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, 2.5 mph, firm surface', '17170', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, 2.5 mph, downhill', '17180', '2.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, 3.0 mph, level, moderate pace, firm surface', '17190', '3.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, 3.5 mph, level, brisk, firm surface, walking for exercise', '17200', '3.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, 3.5 mph, uphill', '17210', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, 4.0 mph, level, firm surface, very brisk pace', '17220', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, 4.5 mph, level, firm surface, very, very brisk', '17230', '6.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, 5.0 mph', '17231', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, for pleasure, work break', '17250', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, grass track', '17260', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking, to work or class (Taylor Code 015)', '17270', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'walking', 'walking to and from an outhouse', '17280', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'boating, power', '18010', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'canoeing, on camping trip (Taylor Code 270)', '18020', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'canoeing, harvesting wild rice, knocking rice off the stalks', '18025', '3.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'canoeing, portaging', '18030', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'canoeing, rowing, 2.0-3.9 mph, light effort', '18040', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'canoeing, rowing, 4.0-5.9 mph, moderate effort', '18050', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'canoeing, rowing, >6 mph, vigorous effort', '18060', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Canoeing', 1, 'water activities', 'canoeing, rowing, for pleasure, general (Taylor Code 250', '18070', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'canoeing, rowing, in competition, or crew or sculling (Taylor Code 260', '18080', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Diving', 1, 'water activities', 'diving, springboard or platform', '18090', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Kayaking', 1, 'water activities', 'kayaking', '18100', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Sailing', 1, 'water activities', 'paddle boat', '18110', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'sailing, boat and board sailing, windsurfing, ice sailing, general (Taylor Code 235)', '18120', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'sailing, in competition', '18130', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'sailing, Sunfish/Laser/Hobby Cat, Keel boats, ocean sailing, yachting', '18140', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Water Skiing', 1, 'water activities', 'skiing, water (Taylor Code 220)', '18150', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Skimobiling', 1, 'water activities', 'skimobiling', '18160', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', '', '18170', '12');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'skindiving, fast', '18180', '16');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'skindiving, moderate', '18190', '12.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Scuba Diving', 1, 'water activities', 'skindiving, scuba diving, general (Taylor Code 310)', '18200', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Snorkeling', 1, 'water activities', 'snorkeling (Taylor Code 320)', '18210', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Surfing', 1, 'water activities', 'surfing, body or board', '18220', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'swimming laps, freestyle, fast, vigorous effort', '18230', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Swimming - Freestyle', 1, 'water activities', 'swimming laps, freestyle, slow, moderate or light effort', '18240', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Swimming - Backstroke', 1, 'water activities', 'swimming, backstroke, general', '18250', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Swimming - Breaststroke', 1, 'water activities', 'swimming, breaststroke, general', '18260', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Swimming - Butterfly', 1, 'water activities', 'swimming, butterfly, general', '18270', '11');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'swimming, crawl, fast (75 yards/minute), vigorous effort', '18280', '11');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'swimming, crawl, slow (50 yards/minute), moderate or light effort', '18290', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'swimming, lake, ocean, river (Taylor Codes 280, 295)', '18300', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'swimming, leisurely, not lap swimming, general', '18310', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Swimming', 1, 'water activities', 'swimming, sidestroke, general', '18320', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Synchronized Swimming', 1, 'water activities', 'swimming, synchronized', '18330', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'swimming, treading water, fast vigorous effort', '18340', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'swimming, treading water, moderate effort, general', '18350', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'water aerobics, water calisthenics', '18355', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Water Polo', 1, 'water activities', 'water polo', '18360', '10');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Water Volleyball', 1, 'water activities', 'water volleyball', '18365', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'water activities', 'water jogging', '18366', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Whitewater Rafting', 1, 'water activities', 'whitewater rafting, kayaking, or canoeing', '18370', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'winter activities', 'moving ice house (set up/drill holes, etc.)', '19010', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'winter activities', 'skating, ice, 9 mph or less', '19020', '5.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Ice Skating', 1, 'winter activities', 'skating, ice, general (Taylor Code 360)', '19030', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'winter activities', 'skating, ice, rapidly, more than 9 mph', '19040', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Speed Skating', 1, 'winter activities', 'skating, speed, competitive', '19050', '15');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Ski Jumping', 1, 'winter activities', 'ski jumping (climb up carrying skis)', '19060', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Skiing/Snowboarding', 1, 'winter activities', 'skiing, general', '19075', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'winter activities', 'skiing, cross country, 2.5 mph, slow or light effort, ski walking', '19080', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Cross Country Skiing', 1, 'winter activities', 'skiing, cross country, 4.0-4.9 mph, moderate speed and effort, genera', '19090', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'winter activities', 'skiing, cross country, 5.0-7.9 mph, brisk speed, vigorous effort', '19100', '9');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'winter activities', 'skiing, cross country, >8.0 mph, racing', '19110', '14');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'winter activities', 'skiing, cross country, hard snow, uphill, maximum, snow mountaineering', '19130', '16.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'winter activities', 'skiing, downhill, light effort', '19150', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Downhill Skiing', 1, 'winter activities', 'skiing, downhill, moderate effort, general', '19160', '6');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'winter activities', 'skiing, downhill, vigorous effort, racing', '19170', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Bobsledding/Luge', 1, 'winter activities', 'sledding, tobogganing, bobsledding, luge (Taylor Code 370)', '19180', '7');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Snow Shoeing', 1, 'winter activities', 'snow shoeing', '19190', '8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('Snowmobiling', 1, 'winter activities', 'snowmobiling', '19200', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'sitting in church, in service, attending a ceremony, sitting quietly', '20000', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'sitting, playing an instrument at church', '20001', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'sitting in church, talking or singing, attending a ceremony, sitting, active participation', '20005', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'sitting, reading religious materials at home', '20010', '1.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'standing in church (quietly), attending a ceremony, standing quietly', '20015', '1.2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'standing, singing in church, attending a ceremony, standing, active participation', '20020', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'kneeling in church/at home (praying)', '20025', 1);
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'standing, talking in church', '20030', '1.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'walking in church', '20035', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'walking, less than 2.0 mph - very slow', '20036', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'walking, 3.0 mph, moderate speed, not carrying anything', '20037', '3.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'walking, 3.5 mph, brisk speed, not carrying anything', '20038', '3.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'walk/stand combination for religious purposes, usher', '20039', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'praise with dance or run, spiritual dancing in church', '20040', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'serving food at church', '20045', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'preparing food at church', '20046', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'washing dishes/cleaning kitchen at church', '20047', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'eating at church', '20050', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'eating/talking at church or standing eating, American Indian Feast days', '20055', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'cleaning church', '20060', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'general yard work at church', '20061', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'standing - moderate (lifting 50 lbs., assembling at fast rate)', '20065', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'standing - moderate/heavy work', '20095', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'religious activities', 'typing, electric, manual, or computer', '20100', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'sitting - meeting, general, and/or with talking involved', '21000', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'sitting - light office work, in general', '21005', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'sitting - moderate work', '21010', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'standing - light work (filing, talking, assembling)', '21015', '2.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'sitting, child care, only active periods', '21016', '2.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'standing, child care, only active periods', '21017', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'walk/run play with children, moderate, only active periods', '21018', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'walk/run play with children, vigorous, only active periods', '21019', '5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'standing - light/moderate work (pack boxes, assemble/repair, set up chairs/furniture)', '21020', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'standing - moderate (lifting 50 lbs., assembling at fast rate)', '21025', '3.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'standing - moderate/heavy work', '21030', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'typing, electric, manual, or computer', '21035', '1.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'walking, less than 2.0 mph, very slow', '21040', '2');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'walking, 3.0 mph, moderate speed, not carrying anything', '21045', '3.3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'walking, 3.5 mph, brisk speed, not carrying anything', '21050', '3.8');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'walking, 2.5 mph slowly and carrying objects less than 25 pounds', '21055', '3');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'walking, 3.0 mph moderately and carrying objects less than 25 pounds, pushing something', '21060', '4');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'walking, 3.5 mph, briskly and carrying objects less than 25 pounds', '21065', '4.5');
INSERT INTO `phr`.`data_exercises_list` (`exercise_description`, `exercise_display`, `acsm_category`, `acsm_description`, `acsm_compcode`, `acsm_mets`) VALUES ('', 0, 'volunteer activities', 'walk/stand combination, for volunteer purposes', '21070', '3');

