/**
 * Copyright (C) 2012 KRM Associates, Inc. healtheme@krminc.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.krminc.phr.api.converter.clinical;

import com.krminc.phr.api.converter.DateAdapter;
import com.krminc.phr.api.converter.DateTimeAdapter;
import com.krminc.phr.api.converter.UriResolver;
import com.krminc.phr.domain.clinical.CcrResult;
import com.krminc.phr.domain.clinical.CcrResultTest;
import java.net.URI;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.ws.rs.core.UriBuilder;
import javax.persistence.EntityManager;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 *
 * @author cmccall
 */

@XmlRootElement(name = "ccrResult")
public class CcrResultConverter extends GenericResultConverter {
    private CcrResult entity;
    private URI uri;
    private int expandLevel;
  
    /** Creates a new instance of CcrResultConverter */
    public CcrResultConverter() {
        entity = new CcrResult();
    }

    /**
     * Creates a new instance of CcrResultConverter.
     *
     * @param localEntity associated localEntity
     * @param uri associated uri
     * @param expandLevel indicates the number of levels the localEntity graph should be expanded@param isUriExtendable indicates whether the uri can be extended
     */
    public CcrResultConverter(CcrResult entity, URI uri, int expandLevel, boolean isUriExtendable) {
        super(entity);
        this.entity = entity;
        this.uri = (isUriExtendable) ? UriBuilder.fromUri(uri).path(entity.getId() + "/").build() : uri;
        this.expandLevel = expandLevel;
        //getResultTests();
    }

    /**
     * Creates a new instance of CcrResultConverter.
     *
     * @param localEntity associated localEntity
     * @param uri associated uri
     * @param expandLevel indicates the number of levels the localEntity graph should be expanded
     */
    public CcrResultConverter(CcrResult entity, URI uri, int expandLevel) {
        this(entity, uri, expandLevel, false);
    }

    /**
     * Getter for id.
     *
     * @return value for id
     */
    @XmlElement
    public Long getId() {
        return (expandLevel > 0) ? entity.getId() : null;
    }

    /**
     * Getter for resultTests.
     *
     * @return value for resultTests
     */
//    @XmlElement
//    public CcrResultTestsConverter getResultTests() {
//        if (expandLevel > 0) {
//            if (entity.getResultTests() != null) {
//                return new CcrResultTestsConverter(entity.getResultTests(), uri.resolve("resultTests/"), expandLevel - 1);
//            }
//        }
//        return null;
//    }

    /**
     * Getter for laboratoryName.
     *
     * @return value for laboratoryName
     */
    @XmlElement
    public String getLaboratoryName() {
        return (expandLevel > 0) ? entity.getLaboratoryName() : null;
    }

    /**
     * Getter for notes.
     *
     * @return value for notes
     */
    @XmlElement
    public String getNotes() {
        return (expandLevel > 0) ? entity.getNotes() : null;
    }

    /**
     * Getter for orderedBy.
     *
     * @return value for orderedBy
     */
    @XmlElement
    public String getOrderedBy() {
        if (expandLevel > 0) {
            String title = entity.getSources().get(0).getActor().getAsFullName();
            if (title != null) return title.toLowerCase();
        }
        return null;
    }

    /**
     * Getter for orderedByTitle.
     *
     * @return value for orderedByTitle
     */
    @XmlElement
    public String getOrderedByTitle() {
        if (expandLevel > 0) {
            String title = entity.getSources().get(0).getActor().getPersonNameCurrentNameTitle();
            if (title != null) return title.toLowerCase();
        }
        return null;
    }

    /**
     * Returns the URI associated with this converter.
     *
     * @return the uri
     */
    @XmlAttribute
    public URI getUri() {
        return uri;
    }

    /** Custom getters (not autogenerated) **/

    /**
     * Getter for dateAdded.
     *
     * @return value for dateAdded
     */
    @XmlElement
    @XmlJavaTypeAdapter(DateTimeAdapter.class)
    public Date getDateAdded() {
        return (expandLevel > 0) ? entity.getDateAdded() : null;
    }

    /**
     * Getter for source.
     *
     * @return value for source
     */
    @XmlElement
    public String getSource() {
        return (expandLevel > 0) ? entity.getSource() : null;
    }

    /**
     * Getter for dateOrdered.
     *
     * @return value for dateOrdered
     */
    @XmlElement
    @XmlJavaTypeAdapter(DateTimeAdapter.class)
    public Date getDateOrdered() {
        return (expandLevel > 0) ? entity.getExactDateTime() : null;
    }

    /** End Custom getters **/

    /**
     * Returns the CcrResult localEntity.
     *
     * @return an localEntity
     */
    @XmlTransient
    public CcrResult getEntity() {
        if (entity.getId() == null) {
            CcrResultConverter converter = UriResolver.getInstance().resolve(CcrResultConverter.class, uri);
            if (converter != null) {
                entity = converter.getEntity();
            }
        }
        return entity;
    }

    /**
     * Returns the resolved CcrResult localEntity.
     *
     * @return an resolved localEntity
     */
    public CcrResult resolveEntity(EntityManager em) {
        List<CcrResultTest> resultTests = entity.getResultTests();
        List<CcrResultTest> newresultTests = new java.util.ArrayList<CcrResultTest>();
        for (CcrResultTest item : resultTests) {
            newresultTests.add(em.getReference(CcrResultTest.class, item.getId()));
        }
        entity.setResultTests(newresultTests);
        return entity;
    }
}
