/*
The anonymizeStreet function 

inputs:
nameIn
seed

outputs:
nameOut

Note: There are 20 streets that all street addresses will map to. Within the
commonData.h (header file), these are located in the streets array. To ensure
common translation, whitespace is removed and the text is converted to upper case.
The reason is a single bit error will result in a vastly different hash value.
Furthermore, the street sources could be from multiple database tables or
other data sources that may use different formatting.

This function used the first number of the hash (message digest) and 
divides this by 214748365. This results in a value between 0 and 19 
inclusive (the index). In turn, this points is used to get the street address 
found at that locations.

Note, the seed is copied so as not to alter the vallue input.

*/


int anonymizeStreet(nameIn, nameOut, seed)
	char nameIn[55]; 
	char nameOut[20];
    unsigned long int seed[8];
	{
		char tempName[55], tempName2[55];
		int index, index2;
		unsigned long int temp[8];

		if (seed[0] == 0)
			return(1);
		copySeed(seed, temp);
		removeBlanks(nameIn, tempName);
		upperString(tempName, tempName2);
		SHA256(tempName2, temp, HASH);
		index = (int) (temp[0] / 214748365); /* 4294967296/20 */
		strcpy(nameOut, streets[index]);

		return(0);

	} 