
/*
The integerToString is a helper function designed to convert a 32-bit
integer to a string. Note, the SSN is a value with 9 digits. That is, it 
must be less than 1 billion in value.
*/

int integerToString(number, stringOut)
	unsigned long number;
    char stringOut[10]; /* SSN string out */
	{
		int nextDigit = 0;
		int index;
		unsigned long multiplier = 100000000;
		for (index = 0; index < 9; index++)
		{
			nextDigit = (int) number / multiplier;
			stringOut[index] = (char)(nextDigit + '0');
			number = number - (nextDigit * multiplier);
			multiplier = multiplier / 10;
		}
		stringOut[9] = '/0'; /* end of string marker */
		return(0);
	}

	/*
	The anonimizzeSSN takes an SSN and common seed in and returns
	an anonymized SSN that includes the original delimiters.

	Inputs:
	ssnIn
	seed

	Outputs:
	ssnOut

	The function copies the seed so as not to alter the calling version.
	The SSN, in text format, is prepared as a 9-digit string (no delimiters).
	This is then hashed. The first returned number of the hash value is added
	to a long unsigned version of the SSN. In turn, the digits in the billions
	are eliminated. The resulting number is then converted to a string by using the 
	integerToString helper function (above). As a final step, the SSN is mapped
	back to the same structure used during the call. 
	*/

int anonymizeSSN(ssnIn, ssnOut, seed)
	char ssnIn[20]; 
	char ssnOut[20];
    unsigned long int seed[8];
	{
		unsigned long tempNum;
		char	ssn[10];
		int	length;
		int index, index2;
		unsigned long int temp[8];

		if (seed[0] == 0)
			return(1);
	
		length = strlen(ssnIn);
		if (length > 20)
			length = 20; 
		copySeed(seed, temp);
		for (index = 0; index < 20; index++)
			ssnOut[index] = '\0';

		for(index=0, index2=0; index<length; index++)
		{
			if ((ssnIn[index]>='0')&(ssnIn[index]<='9'))
				ssn[index2++] = ssnIn[index];

		} /* an SSN without delimiters should be in the ssn string */
		tempNum = (unsigned long)atoi(ssn);
		SHA256(ssn, temp, HASH);
		tempNum = tempNum + temp[0]; /* using hash[0] */
		tempNum = tempNum % 1000000000; /* get rid of the billions */
		integerToString(tempNum, ssn);

		for (index = 0, index2 = 0; index < length; index++)
		{
			if ((ssnIn[index] < '0') | (ssnIn[index] > '9'))
				ssnOut[index] = ssnIn[index]; /* capture delimiters */
			else
			{
				ssnOut[index] = ssn[index2++];
			}
		}
		return(0);

	} 
