


	/*
	The anonimizzeNumber takes an SSN, EDI-PI, or beneficiary number
	and returns an anonymized SSN that includes the original delimiters numberIn.

	Inputs:
	NUMBERIn
	seed

	Outputs:
	NUMBEROut


	*/

int anonymizeNumber(numberIn, numberOut, seed)
	char numberIn[20]; 
	char numberOut[20];
    unsigned long int seed[8];
	{
		unsigned long tempNum;
		char tempChar;
		char	number[20];
		int	length, numberLength;
		int index, index2, index3=0;
		unsigned long int temp[8];

		if (seed[0] == 0)
			return(1);
	
		length = strlen(numberIn);
		if (length > 20)
			length = 20; 
		copySeed(seed, temp);
		for (index = 0; index < 20; index++) /* clear buffers */
		{
			numberOut[index] = '\0';
			number[index] = '\0';
		}

		for(index=0, index2=0; index<length; index++)
		{
			if ((numberIn[index]>='0')&(numberIn[index]<='9'))
				number[index2++] = numberIn[index];

		} /* an SSN without delimiters should be in the ssn string */
		SHA256(number, temp, HASH);

		/*
		The next piece of code tahkes the hashed value to create 
		replacement numbers. To accomplish this, 8-bits are shifted
		out of the message digest per digit. This character is then
		dvided by 13. This produces a number between -9 and 9 inclusive. 

		Quick math shows numbers 117 - 127 will produce a 9. Thus, a 0
		is more likely to occur than is a 9. However, 0's often present 
		problems then they are lead numbers. To adjust this, we Take half
		of the 9's and swap with zeros. This results in fewer zeros than 
		other numbers.
		*/


		for (index = 0; index < length; index++)
		{
			if ((numberIn[index] < '0') | (numberIn[index] > '9'))
				numberOut[index] = numberIn[index]; /* capture delimiters */
			else
			{
				if((index3 % 4) == 0)
				{
					tempNum = temp[index3 / 4]; 
				}
				tempChar = '\0';
				if (0x00000001 & tempNum)
					tempChar ^= 0x80; /* move a 1 in */
				tempNum >>= 1;
				for (index2=0; index2<7; index2++)
				{
					tempNum >>= 1; /* shift right 1 */
					tempChar >>= 1;
					if (0x00000001 & tempNum)
						tempChar ^= 0x80; /* move a 1 in */
				}
				index3 += 1;
				tempChar = tempChar/13;
				if ((int)tempChar < 0)
					tempChar ^= 0xff; /* bitwise invert */

				if (tempChar == 0)
					tempChar = 9;
				else
					if (tempChar == 9)
						tempChar = 0;

				numberOut[index] = tempChar + '0'; /* start at 0 */
				
			}
		}
		return(0);

	} 
