/*
The anonymizeFirstNameFemale changes the first name for females

Input:
nameIn
seed

Output:
nameOut

The name in is converted to upper case characters then hashed using the
common seed. Note: the seed is copied before use so the calling version
does not change. 

All names convert into one of the 100 most common first names. These names 
are contained in an array located in the commonData.h header file. To 
determine the name to substitute, the third number of the hash (message digest) 
is divided by 42,949,673. This results in an integer from 0 to 99 inclusive. 
This derived value, the index, is used to select the firstNameFemle array
name. Thus, every first name female will translate to one of the 100 most 
common names. This also means that many names will map to the same name.

*/

int anonymizeFirstNameFemale(nameIn, nameOut, seed)
	char nameIn[55]; 
	char nameOut[20];
    unsigned long int seed[8];
	{
		char tempName[55];
		int index;
		unsigned long int temp[8];

		if (seed[5] == 0)
			return(1);
		copySeed(seed, temp);

	    upperString(nameIn, tempName);
		SHA256(tempName, temp, HASH);
		index = (int) (temp[3] / 42949673); /* 4294967296/100 */
		strcpy(nameOut, firstNameFemale[index]);

		return(0);

	} 
