/*
The anonymizeCity takes an input city (nameIn). Three of the arguments are outputs:
cityOut
stateOut
zipOut
It is expected these returned values will be used to replace the equivalent values
in the calling process. The data used provides city, state, and zip values that
are real. For example, Los Angeles, California instead of Los Angeles in another state.
By converting to some reasonable location, the hope is relying applications 
can operate with minimum modification.

Note the index assignment is calculated by dividing by 42949673. This will provide
a value between 0 and 99 inclusive. This can then be used as an array index where
the translated information resides.

Also note, any city will map into only one out of 100 possibilities. So while there 
are thousands of American cities, only 100 will ever be used. This makes recovery of
the original city difficult at best.

Another point, the source information could be multiple databases, data marts, or 
data warehouses. In turn, these could represent the information in different formats.
For the anomization to be consistent, the city string removes blanks and converts to
upper case before hashing.
*/


int anonymizeCity(nameIn, cityOut, stateOut, zipOut, seed)
	char nameIn[55]; 
	char cityOut[20];
	char stateOut[20];
	char zipOut[10];
    unsigned long int seed[8];
	{
		char tempName[55], tempName2[55];
		int index, index2;
		unsigned long int temp[8];

		if (seed[0] == 0)
			return(1);
		copySeed(seed, temp); /* don't alter the original seed */
		removeBlanks(nameIn, tempName);
		upperString(tempName, tempName2);
		SHA256(tempName2, temp, HASH);
		index = (int) (temp[0] / 42949673); /* 4294967296/100 */
		/* printf("Index: %d\n", index); */
		distribution[index] += 1; /* track the numbers */
		strcpy(cityOut, cities[index]);
		strcpy(stateOut, states[index]);
		strcpy(zipOut, zipCodes[index]);

		return(0);

	} 
