

#include "commonData.h"


/*****************************/
/* From the SHA-256 Standard */
/*****************************/


unsigned long Ch(x, y, z)
 unsigned long x, y, z;
{
	return((x&y)^(~x&z));
}

unsigned long Maj(x, y, z)
 unsigned long x, y, z;
{
	return((x&y)^(x&z)^(y&z));
}

unsigned long ROTR(x, n)
 unsigned long x;
 int n;
{

	if (n < 33)
		return ((x >> n) | (x << (32-n)));
	else
		return (0);
}

unsigned long SHR(x, n)
 unsigned long x;
 int	n;
 {
	 return (x >> n);
 }

unsigned long Sigma0(x)
 unsigned long x;
{
	return(ROTR(x,2) ^ ROTR(x, 13) ^ ROTR(x,22));
}

unsigned long Sigma1(x)
 unsigned long x;
{
	return(ROTR(x, 6) ^ ROTR(x,11) ^ ROTR(x, 25));
}

unsigned long sigma2(x)
 unsigned long x;
{
	return(ROTR(x,7) ^ ROTR(x, 18) ^ SHR(x, 3));
}


unsigned long sigma3(x)
 unsigned long x;
{
	return(ROTR(x, 17) ^ ROTR(x, 19) ^ SHR(x, 10));
}

#define SEED 1
#define HASH 0
#define NO_SEED 1 /* No seed value was passed error */
#define OK /* No error detected */


 /*********************************************************
 The main SHA 256 Function
 *********************************************************/

int SHA256(StringIn, H, HashOrSeed)
	char StringIn[56]; /* 55 character limit in */
	unsigned long H[8]; /* The Message Digest */
	int HashOrSeed; /* do we want to create the seed */
	{
int    counter;
int counter2 = 0;
unsigned long T1, T2, a, b, c, d, e, f, g, h, w[64];
unsigned long const mask = 0x80000000;

unsigned int count=0, i, j, index=0, last_block=0, done=0;
char	temp = '\0';
unsigned long bit_count = 0;
unsigned long temp_word;
int	size;

unsigned long const k[64] = 
{0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5, 0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
 0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3, 0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
 0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc, 0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
 0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7, 0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
 0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13, 0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
 0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3, 0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
 0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5, 0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
 0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208, 0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2};

if (HashOrSeed == SEED) { /* if seed is 0, then hash random value */
	 H[0] = (unsigned long)0x6a09e667;
	 H[1] = (unsigned long)0xbb67ae85;
	 H[2] = (unsigned long)0x3c6ef372;
	 H[3] = (unsigned long)0xa54ff53a;
	 H[4] = (unsigned long)0x510e527f;
	 H[5] = (unsigned long)0x9b05688c;
	 H[6] = (unsigned long)0x1f83d9ab;
	 H[7] = (unsigned long)0x5be0cd19;
}
size = strlen(StringIn);
if (size > 55) {
	size = 55; /* hard limit the size */
	StringIn[55] = '\0'; /* end of string mark */
} /* force an end of line */
bit_count = ((size * 8) + 1); /*the number of bits in the hash */


	for (i=0; i<16; i++) /* Start padding */
	  w[i] = 0;

	
    while (size > 0) {

	   w[15] = bit_count;  /* This is the lenght in bits */

	for (i =0; i<16; i++) {

		for (j=0, temp_word =0; j<4,done==0; j++) { 
	     if (size == 0) { /* test for end of file */ 
		   temp_word += (unsigned long)(0x80 << ((3 - j)*8)); /* position byte */
		   done = 1;
		   w[i] = temp_word;
		   break; }
	       temp = StringIn[count];
		   temp_word += (unsigned long)(temp << ((3 - j)*8)); 
	       count += 1; /* for each byte loaded = 8-bits */
		   size -= 1; /* Decrement size */
	      
		 }     
	      
	 if (done == 0)
	   w[i] = temp_word; /* Load in the next word */
	}
	
}
		
	 for (index =16; index < 64; index++)
		 w[index] = sigma3(w[index-2]) + w[index-7] + sigma2(w[index-15]) + w[index-16];
	a = H[0];
	b = H[1];
	c = H[2];
	d = H[3];
	e = H[4];
	f = H[5];
	g = H[6];
	h = H[7];
	for (count = 0; count < 64; count++)
	{
		T1 = h + Sigma1(e) + Ch(e,f,g) + k[count] + w[count];
		T2 = Sigma0(a) + Maj(a,b,c);
		h = g;
		g = f;
		f = e;
		e = d + T1;
		d = c;
		c = b;
		b = a;
		a = T1 + T2;
	}
	H[0] += a;
	H[1] += b;
	H[2] += c;
	H[3] += d;
	H[4] += e;
	H[5] += f;
	H[6] += g;
	H[7] += h;
	return(0);
	
}
