/*
The streetsTest.c program is a test fixture for the anonymizeStreet function.

The test shows the street in and out.

*/
#include <stdio.h>
#include <string.h>
#include "CommonFunctions.c"
#include "createSeed.c"
#include "testAids.c"
#include "helperFunctions.c"
#include "anonymizeStreet.c"


main(argc, argv)
int  argc;
char *argv[];
{
	unsigned long seed[8];
	FILE	*ptr;
	char inName[55];
	char outName[20];

  if(argc != 2)
  {
	  printf("There must be a second argumet that is a valid filename, %d arguments\n",argc);
	  exit(1); } 
  ptr = fopen(argv[1],"r");
  if (ptr == NULL) {
    printf("Unable to open %s file for reading\n, argv[1]");
    exit(1); }


	createSeed(seed);

		while (fgets(inName, 55, ptr)) {
    
	  if (feof(ptr))
		  break;

	  if (strlen(inName) >1 ) { /* all strings have at least a length of 1 */
		  {
			  anonymizeStreet(inName, outName, seed);
		  }
	 printf("In: %s Out: %s\n", inName, outName); } 
  }


  fclose(ptr);

	
}