



#include <time.h>
#include "commonFunctions.c"


/* The purpoe of the creatSeed function is to create a common one-time
   value that consistently reflects a common person, place, or event. In this way,
   if multiple data surces are converted using the same seed, the result will tie
   a particular person, place, or event while masking the actual identities.

   Note, the user is prompted to enter in a random sequence of characters. Then
   a time value is further used to randomize the event.

   Normally, the characters entered are not displayed. This test shows
   what was entered. What's more, if the same characters re entered, the 
   initial hash value should be the same. All white space is significant.

   Looking at the third number in the second hash value, the clock ticks
   were added.

   Finally, the random string is hashed once again using the new initialization.
   This produces the final resulting value.
*/

int createSeed(S)
	unsigned long int S[8];
{
	char test[55];
	long int time;
	int count;
	for(count=0; count<56; count++)
		test[count] = '\0'; /* clear buffer */
	count = 0;
	printf("Please enter some random characters\n");
	test[count] = getch();
	putchar('*'); /* hide text entered */
	while (((test[count]) != 13)&(count < 54))
	{
		count += 1;
		test[count] = getch();
		putchar('*'); /* hide text entered */
	}
	printf("\nThe string entered was: %s\n",test);
	SHA256(test, S, SEED); /* a 0 forces an initialization using default SHA values */
	time = clock();
	printf("The hash of the random string entered\n");
	printf("%lu %lu %lu %lu %lu %lu %lu %lu\n", 
		S[0],S[1],S[2],S[3],S[4],S[5],S[6],S[7]);
	S[2] ^= time; /* modify the seed to include a time component */
	printf("The hash with time added to the third value\n");
	printf("%lu %lu %lu %lu %lu %lu %lu %lu\n",
		S[0],S[1],S[2],S[3],S[4],S[5],S[6],S[7]);
	SHA256(test, S, HASH); /* a value of 1 means use the current seed value */
	printf("The final hash is now the seed:\n");
	printf("%lu %lu %lu %lu %lu %lu %lu %lu\n",
		S[0],S[1],S[2],S[3],S[4],S[5],S[6],S[7]);


	return (0);
}

main(argc, argv)
int  argc;
char *argv[];
{
	unsigned long seed[8];
	createSeed(seed);
}
