/*
The purpose of the citiesTest.c program is to take in a city name and return 
a city, state and zip code. The reason for not mixing up the states and 
cities is to provide a more realistic anonymization.
*/

#include <stdio.h>
#include <string.h>
#include "CommonFunctions.c"
#include "createSeed.c"
#include "testAids.c"
#include "helperFunctions.c"
#include "anonymizeCity.c"

main(argc, argv)
int  argc;
char *argv[];
{
	unsigned long seed[8];
	FILE	*ptr; 
	char inName[55];
	char outName[20];
	char state[20];
	char zip[10];

  if(argc != 2)
  {
	  printf("There must be a second argumet that is a valid filename, %d arguments\n",argc);
	  exit(1); } 
  ptr = fopen(argv[1],"r");
  if (ptr == NULL) {
    printf("Unable to open %s file for reading\n, argv[1]");
    exit(1); }

	createSeed(seed);

		while (fgets(inName, 55, ptr)) {
    
	  if (feof(ptr))
		  break;
	  if (strlen(inName) >1 ) { /* all strings have at least a length of 1 */
	    anonymizeCity(inName, outName, state, zip, seed);
	    printf("In: %s\t Out: %s, %s, %s\n", inName, outName, state, zip); 
	  } 
  }


  fclose(ptr);

	
}