
/*
The FirstNameFemaleTest.c test fixture calls the anonymizeFirstNameFemale
function. Note, the createSeed is called first. The test fixture prints the
name in and name out values.
*/
#include <stdio.h>
#include <string.h>
#include "CommonFunctions.c"
#include "createSeed.c"
#include "testAids.c"
#include "helperFunctions.c"
#include "anonymizeFirstNameFemale.c"

main(argc, argv)
int  argc;
char *argv[];
{
	unsigned long seed[8];
	FILE	*ptr; 
	char inName[55];
	char outName[20];

  if(argc != 2)
  {
	  printf("There must be a second argumet that is a valid filename, %d arguments\n",argc);
	  exit(1); } 
  ptr = fopen(argv[1],"r");
  if (ptr == NULL) {
    printf("Unable to open %s file for reading\n, argv[1]");
    exit(1); }
	
	createSeed(seed);

	while (fscanf(ptr,"%s", inName)) {
    
	  if (feof(ptr))
		  break;
	  anonymizeFirstNameFemale(inName, outName, seed);
	  printf("In: %s\t\t Out: %s\n",inName, outName); 
  }


  fclose(ptr);
	
}